/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarTypeBaseDate;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import io.ebean.core.type.ScalarTypeUtils;
import io.ebeaninternal.server.type.UtilDateParser;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

final class ScalarTypeUtilDate {
    ScalarTypeUtilDate() {
    }

    static final class DateType
    extends ScalarTypeBaseDate<Date> {
        DateType(JsonConfig.Date mode) {
            super(mode, Date.class, false, 91);
        }

        protected String toIsoFormat(Date value) {
            return UtilDateParser.format(value);
        }

        public long convertToMillis(Date value) {
            return value.getTime();
        }

        public Date convertFromDate(java.sql.Date ts) {
            return new Date(ts.getTime());
        }

        public java.sql.Date convertToDate(Date date) {
            return new java.sql.Date(date.getTime());
        }

        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toDate((Object)value);
        }

        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate((Object)value);
        }
    }

    static final class TimestampType
    extends ScalarTypeBaseDateTime<Date> {
        TimestampType(JsonConfig.DateTime mode) {
            super(mode, Date.class, false, 93);
        }

        protected String toJsonNanos(Date value) {
            return String.valueOf(value.getTime());
        }

        protected String toJsonISO8601(Date value) {
            return ScalarTypeUtils.formatInstant((Instant)value.toInstant());
        }

        public long convertToMillis(Date value) {
            return value.getTime();
        }

        public Date read(DataReader reader) throws SQLException {
            Timestamp timestamp = reader.getTimestamp();
            if (timestamp == null) {
                return null;
            }
            return new Date(timestamp.getTime());
        }

        public void bind(DataBinder binder, Date value) throws SQLException {
            if (value == null) {
                binder.setNull(93);
            } else {
                binder.setTimestamp(new Timestamp(value.getTime()));
            }
        }

        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toTimestamp((Object)value);
        }

        public Date toBeanType(Object value) {
            return BasicTypeConverter.toUtilDate((Object)value);
        }

        public Date convertFromTimestamp(Timestamp ts) {
            return new Date(ts.getTime());
        }

        public Date convertFromInstant(Instant ts) {
            return new Date(ts.toEpochMilli());
        }

        public Timestamp convertToTimestamp(Date date) {
            return new Timestamp(date.getTime());
        }

        public Date convertFromMillis(long systemTimeMillis) {
            return new Date(systemTimeMillis);
        }
    }
}

