/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;

class ScalarTypeLocalTime
extends ScalarTypeBase<LocalTime> {
    ScalarTypeLocalTime() {
        super(LocalTime.class, false, 92);
    }

    ScalarTypeLocalTime(int jdbcTtype) {
        super(LocalTime.class, false, jdbcTtype);
    }

    public void bind(DataBinder binder, LocalTime value) throws SQLException {
        if (value == null) {
            binder.setNull(92);
        } else {
            binder.setTime(Time.valueOf(value));
        }
    }

    public LocalTime read(DataReader reader) throws SQLException {
        Time time = reader.getTime();
        return time == null ? null : time.toLocalTime();
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Time) {
            return value;
        }
        return Time.valueOf((LocalTime)value);
    }

    public LocalTime toBeanType(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value == null) {
            return null;
        }
        return BasicTypeConverter.toTime((Object)value).toLocalTime();
    }

    public LocalTime readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return LocalTime.ofNanoOfDay(dataInput.readLong());
    }

    public void writeData(DataOutput dataOutput, LocalTime value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(value.toNanoOfDay());
        }
    }

    public String formatValue(LocalTime v) {
        return v.toString();
    }

    public LocalTime parse(String value) {
        return LocalTime.parse(value);
    }

    public LocalTime jsonRead(JsonParser parser) throws IOException {
        return LocalTime.parse(parser.getValueAsString());
    }

    public void jsonWrite(JsonGenerator writer, LocalTime value) throws IOException {
        writer.writeString(value.toString());
    }

    public DocPropertyType docType() {
        return DocPropertyType.KEYWORD;
    }
}

