/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.ScalarTypeBaseVarchar;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ConvertInetAddresses;
import java.net.InetAddress;

final class ScalarTypeInetAddress
extends ScalarTypeBaseVarchar<InetAddress> {
    ScalarTypeInetAddress() {
        super(InetAddress.class);
    }

    public int length() {
        return 50;
    }

    public InetAddress convertFromDbString(String dbValue) {
        try {
            return this.parse(dbValue);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error with InetAddresses [" + dbValue + "] " + e);
        }
    }

    public String convertToDbString(InetAddress beanValue) {
        return ConvertInetAddresses.toUriString(beanValue);
    }

    public String formatValue(InetAddress v) {
        return ConvertInetAddresses.toUriString(v);
    }

    public InetAddress parse(String value) {
        try {
            return ConvertInetAddresses.forUriString(value);
        }
        catch (IllegalArgumentException e) {
            throw new TextException("Error with InetAddresses [{}]", value, (Exception)e);
        }
    }
}

