/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import java.util.Collection;

public final class MultiValueWrapper {
    private final Collection<?> values;
    private final Class<?> type;

    public MultiValueWrapper(Collection<?> values, Class<?> type) {
        this.values = values;
        this.type = type;
    }

    public MultiValueWrapper(Collection<?> values) {
        this.values = values;
        this.type = values.iterator().next().getClass();
    }

    public Collection<?> getValues() {
        return this.values;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Array[" + this.values.size() + "]={");
        for (Object value : this.values) {
            sb.append(value).append(',');
            if (sb.length() <= 50) continue;
            sb.append("...}");
            return sb.toString();
        }
        sb.setLength(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }
}

