/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.avaje.applog.AppLog;
import io.avaje.lang.NonNullApi;
import io.ebean.config.BackgroundExecutorWrapper;
import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.server.executor.DaemonExecutorService;
import io.ebeaninternal.server.executor.DaemonScheduleThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@NonNullApi
public final class DefaultBackgroundExecutor
implements SpiBackgroundExecutor {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.BackgroundExecutor");
    private final ScheduledExecutorService schedulePool;
    private final DaemonExecutorService pool;
    private final BackgroundExecutorWrapper wrapper;

    public DefaultBackgroundExecutor(int schedulePoolSize, int shutdownWaitSeconds, String namePrefix, BackgroundExecutorWrapper wrapper) {
        this.schedulePool = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix + "-periodic-");
        this.pool = new DaemonExecutorService(shutdownWaitSeconds, namePrefix);
        this.wrapper = wrapper;
    }

    <T> Callable<T> wrap(Callable<T> task) {
        if (this.wrapper == null) {
            return task;
        }
        return this.wrapper.wrap(task);
    }

    Runnable wrap(Runnable task) {
        if (this.wrapper == null) {
            return task;
        }
        return this.wrapper.wrap(task);
    }

    private Runnable logExceptions(Runnable task) {
        long queued = System.nanoTime();
        log.log(System.Logger.Level.TRACE, "Queued {0}", task);
        return () -> {
            try {
                if (log.isLoggable(System.Logger.Level.TRACE)) {
                    long start = System.nanoTime();
                    log.log(System.Logger.Level.TRACE, "Start {0} (delay time {1} us)", task, (start - queued) / 1000L);
                    task.run();
                    log.log(System.Logger.Level.TRACE, "Stop {0} (exec time {1} us)", task, (System.nanoTime() - start) / 1000L);
                } else {
                    task.run();
                }
            }
            catch (Throwable t) {
                log.log(System.Logger.Level.ERROR, "Error while executing the task " + task, t);
                throw t;
            }
        };
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.pool.submit(this.wrap(task));
    }

    public Future<?> submit(Runnable task) {
        return this.pool.submit(this.wrap(task));
    }

    public void execute(Runnable task) {
        this.submit(this.logExceptions(task));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.schedulePool.scheduleWithFixedDelay(this.logExceptions(task), initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.schedulePool.scheduleAtFixedRate(this.logExceptions(task), initialDelay, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.schedulePool.schedule(this.logExceptions(task), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.schedulePool.schedule(task, delay, unit);
    }

    @Override
    public void shutdown() {
        log.log(System.Logger.Level.TRACE, "BackgroundExecutor shutting down");
        this.schedulePool.shutdown();
        this.pool.shutdown();
        log.log(System.Logger.Level.DEBUG, "BackgroundExecutor stopped");
    }
}

