/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.meta;

import io.ebean.bean.EntityBean;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.BeanPropertyIdClass;
import io.ebeaninternal.server.deploy.BeanPropertyJsonBasic;
import io.ebeaninternal.server.deploy.BeanPropertyJsonMapper;
import io.ebeaninternal.server.deploy.BeanPropertyOrderColumn;
import io.ebeaninternal.server.deploy.BeanPropertySimpleCollection;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertySimpleCollection;
import io.ebeaninternal.server.properties.BeanPropertySetter;
import io.ebeaninternal.server.type.ScalarTypeString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class DeployBeanPropertyLists {
    private static final NoopSetter NOOP_SETTER = new NoopSetter();
    private BeanProperty versionProperty;
    private BeanProperty unmappedJson;
    private BeanProperty draft;
    private BeanProperty draftDirty;
    private BeanProperty tenant;
    private final BeanDescriptor<?> desc;
    private final LinkedHashMap<String, BeanProperty> propertyMap;
    private BeanProperty id;
    private final List<BeanProperty> local = new ArrayList<BeanProperty>();
    private final List<BeanProperty> mutable = new ArrayList<BeanProperty>();
    private final List<BeanPropertyAssocMany<?>> manys = new ArrayList();
    private final List<BeanProperty> nonManys = new ArrayList<BeanProperty>();
    private final List<BeanProperty> aggs = new ArrayList<BeanProperty>();
    private final List<BeanPropertyAssocOne<?>> ones = new ArrayList();
    private final List<BeanPropertyAssocOne<?>> onesImported = new ArrayList();
    private final List<BeanPropertyAssocOne<?>> embedded = new ArrayList();
    private final List<BeanProperty> baseScalar = new ArrayList<BeanProperty>();
    private final List<BeanProperty> transients = new ArrayList<BeanProperty>();
    private final List<BeanProperty> nonTransients = new ArrayList<BeanProperty>();
    private final BeanPropertyAssocOne<?> unidirectional;
    private final BeanProperty orderColumn;

    public DeployBeanPropertyLists(BeanDescriptorMap owner, BeanDescriptor<?> desc, DeployBeanDescriptor<?> deploy) {
        this.desc = desc;
        DeployBeanPropertyAssocOne<?> deployId = deploy.getIdClassProperty();
        if (deployId != null) {
            this.id = new BeanPropertyIdClass(owner, (BeanDescriptor)desc, (DeployBeanPropertyAssocOne)deployId);
            this.setImportedPrimaryKeysFor(deploy, deployId);
        } else {
            this.setImportedPrimaryKeys(deploy);
        }
        DeployBeanProperty deployOrderColumn = deploy.getOrderColumn();
        this.orderColumn = deployOrderColumn != null ? new BeanPropertyOrderColumn(desc, deployOrderColumn) : null;
        DeployBeanPropertyAssocOne<?> deployUnidirectional = deploy.getUnidirectional();
        this.unidirectional = deployUnidirectional == null ? null : new BeanPropertyAssocOne(owner, desc, deployUnidirectional);
        this.propertyMap = new LinkedHashMap();
        String discriminatorColumn = null;
        BeanProperty discProperty = null;
        InheritInfo inheritInfo = deploy.getInheritInfo();
        if (inheritInfo != null) {
            discriminatorColumn = inheritInfo.getDiscriminatorColumn();
            DeployBeanProperty discDeployProp = new DeployBeanProperty(deploy, String.class, (ScalarType<?>)ScalarTypeString.INSTANCE, null);
            discDeployProp.setDiscriminator();
            discDeployProp.setName(discriminatorColumn);
            discDeployProp.setDbColumn(discriminatorColumn);
            discDeployProp.setSetter(NOOP_SETTER);
            discProperty = new BeanProperty(desc, discDeployProp);
        }
        for (DeployBeanProperty prop : deploy.propertiesAll()) {
            if (discriminatorColumn != null && discriminatorColumn.equals(prop.getDbColumn())) {
                prop.setDiscriminator();
                discProperty = null;
            }
            BeanProperty beanProp = this.createBeanProperty(owner, prop);
            this.propertyMap.put(beanProp.name(), beanProp);
        }
        int order = 0;
        for (BeanProperty prop : this.propertyMap.values()) {
            prop.setDeployOrder(order++);
            this.allocateToList(prop);
        }
        if (this.orderColumn != null) {
            this.orderColumn.setDeployOrder(order);
            this.allocateToList(this.orderColumn);
            this.propertyMap.put(this.orderColumn.name(), this.orderColumn);
        }
        if (discProperty != null) {
            this.propertyMap.put(discProperty.name(), discProperty);
        }
    }

    private void setImportedPrimaryKeys(DeployBeanDescriptor<?> deploy) {
        DeployBeanProperty id = deploy.idProperty();
        if (id instanceof DeployBeanPropertyAssocOne) {
            this.setImportedPrimaryKeysFor(deploy, (DeployBeanPropertyAssocOne)id);
        }
    }

    private void setImportedPrimaryKeysFor(DeployBeanDescriptor<?> deploy, DeployBeanPropertyAssocOne<?> id) {
        for (DeployBeanProperty prop : id.getTargetDeploy().properties()) {
            DeployBeanProperty match = this.findImported(deploy, prop);
            if (match == null) continue;
            match.setImportedPrimaryKeyColumn(prop);
        }
    }

    private DeployBeanProperty findImported(DeployBeanDescriptor<?> deploy, DeployBeanProperty embeddedScalar) {
        String name = embeddedScalar.getName();
        String dbColumn = embeddedScalar.getDbColumn();
        DeployBeanProperty match = deploy.getBeanProperty(name);
        if (match != null) {
            return match;
        }
        for (DeployBeanPropertyAssocOne<?> assocOne : deploy.propertiesAssocOne()) {
            if (!name.equals(assocOne.getName()) && (dbColumn == null || !dbColumn.equals(assocOne.getDbColumn()))) continue;
            return assocOne;
        }
        return null;
    }

    public BeanPropertyAssocOne<?> getUnidirectional() {
        return this.unidirectional;
    }

    public BeanProperty getOrderColumn() {
        return this.orderColumn;
    }

    private void allocateToList(BeanProperty prop) {
        if (prop.isTransient()) {
            this.transients.add(prop);
            if (prop.isDraft()) {
                this.draft = prop;
            }
            if (prop.isUnmappedJson()) {
                this.unmappedJson = prop;
            }
            return;
        }
        if (prop.isId()) {
            if (this.id != null) {
                throw new IllegalStateException("More that one @Id property on " + this.desc.fullName() + " ?");
            }
            this.id = prop;
            return;
        }
        this.nonTransients.add(prop);
        if (prop.isMutableScalarType()) {
            this.mutable.add(prop);
        }
        if (this.desc.inheritInfo() != null && prop.isLocal()) {
            this.local.add(prop);
        }
        if (prop instanceof BeanPropertyAssocMany) {
            this.manys.add((BeanPropertyAssocMany)prop);
        } else {
            this.nonManys.add(prop);
            if (prop.isAggregation()) {
                this.aggs.add(prop);
            }
            if (prop.isTenantId()) {
                this.tenant = prop;
            }
            if (prop instanceof BeanPropertyAssocOne) {
                BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)prop;
                if (prop.isEmbedded()) {
                    this.embedded.add(assocOne);
                } else {
                    this.ones.add(assocOne);
                    if (!assocOne.isOneToOneExported()) {
                        this.onesImported.add(assocOne);
                    }
                }
            } else {
                if (prop.isVersion()) {
                    if (this.versionProperty == null) {
                        this.versionProperty = prop;
                    } else {
                        CoreLog.internal.log(System.Logger.Level.WARNING, "Multiple @Version properties - property " + prop.fullName() + " not treated as a version property");
                    }
                } else if (prop.isDraftDirty()) {
                    this.draftDirty = prop;
                }
                if (!prop.isAggregation()) {
                    this.baseScalar.add(prop);
                }
            }
        }
    }

    public LinkedHashMap<String, BeanProperty> getPropertyMap() {
        return this.propertyMap;
    }

    public BeanProperty[] getBaseScalar() {
        return this.baseScalar.toArray(new BeanProperty[0]);
    }

    public BeanProperty getId() {
        return this.id;
    }

    public BeanProperty[] getNonTransients() {
        return this.nonTransients.toArray(new BeanProperty[0]);
    }

    public BeanProperty[] getTransients() {
        return this.transients.toArray(new BeanProperty[0]);
    }

    public BeanProperty getVersionProperty() {
        return this.versionProperty;
    }

    public BeanProperty[] getLocal() {
        return this.local.toArray(new BeanProperty[0]);
    }

    public BeanProperty[] getMutable() {
        return this.mutable.toArray(new BeanProperty[0]);
    }

    public BeanPropertyAssocOne<?>[] getEmbedded() {
        return this.embedded.toArray(new BeanPropertyAssocOne[0]);
    }

    public BeanPropertyAssocOne<?>[] getOneImported() {
        return this.onesImported.toArray(new BeanPropertyAssocOne[0]);
    }

    public BeanPropertyAssocOne<?>[] getOnes() {
        return this.ones.toArray(new BeanPropertyAssocOne[0]);
    }

    public BeanPropertyAssocOne<?>[] getOneExportedSave() {
        return this.getOne(false, Mode.Save);
    }

    public BeanPropertyAssocOne<?>[] getOneExportedDelete() {
        return this.getOne(false, Mode.Delete);
    }

    public BeanPropertyAssocOne<?>[] getOneImportedSave() {
        return this.getOne(true, Mode.Save);
    }

    public BeanPropertyAssocOne<?>[] getOneImportedDelete() {
        return this.getOne(true, Mode.Delete);
    }

    public BeanProperty[] getNonMany() {
        return this.nonManys.toArray(new BeanProperty[0]);
    }

    public BeanProperty[] getAggregates() {
        return this.aggs.toArray(new BeanProperty[0]);
    }

    public BeanPropertyAssocMany<?>[] getMany() {
        return this.manys.toArray(new BeanPropertyAssocMany[0]);
    }

    public BeanPropertyAssocMany<?>[] getManySave() {
        return this.getMany(Mode.Save);
    }

    public BeanPropertyAssocMany<?>[] getManyDelete() {
        return this.getMany(Mode.Delete);
    }

    public BeanPropertyAssocMany<?>[] getManyToMany() {
        return this.getMany2Many();
    }

    public BeanProperty getDraftDirty() {
        return this.draftDirty;
    }

    public BeanProperty getUnmappedJson() {
        return this.unmappedJson;
    }

    public BeanProperty getDraft() {
        return this.draft;
    }

    public BeanProperty getSoftDeleteProperty() {
        for (BeanProperty prop : this.nonManys) {
            if (!prop.isSoftDelete()) continue;
            return prop;
        }
        return null;
    }

    public BeanProperty getTenant() {
        return this.tenant;
    }

    public BeanProperty[] getGeneratedInsert() {
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (BeanProperty prop : this.nonTransients) {
            GeneratedProperty gen = prop.generatedProperty();
            if (gen == null || !gen.includeInInsert()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanProperty[0]);
    }

    public BeanProperty[] getGeneratedUpdate() {
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (BeanProperty prop : this.nonTransients) {
            GeneratedProperty gen = prop.generatedProperty();
            if (gen == null || !gen.includeInUpdate()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanProperty[0]);
    }

    private BeanPropertyAssocOne<?>[] getOne(boolean imported, Mode mode) {
        ArrayList list = new ArrayList();
        for (BeanPropertyAssocOne<?> prop : this.ones) {
            if (imported == prop.isOneToOneExported()) continue;
            switch (mode) {
                case Save: {
                    if (!prop.cascadeInfo().isSave()) break;
                    list.add(prop);
                    break;
                }
                case Delete: {
                    if (!prop.cascadeInfo().isDelete()) break;
                    list.add(prop);
                    break;
                }
            }
        }
        return list.toArray(new BeanPropertyAssocOne[0]);
    }

    private BeanPropertyAssocMany<?>[] getMany2Many() {
        ArrayList list = new ArrayList();
        for (BeanPropertyAssocMany<?> prop : this.manys) {
            if (!prop.isManyToMany()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanPropertyAssocMany[0]);
    }

    private BeanPropertyAssocMany<?>[] getMany(Mode mode) {
        ArrayList list = new ArrayList();
        for (BeanPropertyAssocMany<?> prop : this.manys) {
            switch (mode) {
                case Save: {
                    if (!prop.isIncludeCascadeSave()) break;
                    list.add(prop);
                    break;
                }
                case Delete: {
                    if (!prop.isIncludeCascadeDelete()) break;
                    list.add(prop);
                    break;
                }
            }
        }
        return list.toArray(new BeanPropertyAssocMany[0]);
    }

    private BeanProperty createBeanProperty(BeanDescriptorMap owner, DeployBeanProperty deployProp) {
        if (deployProp instanceof DeployBeanPropertyAssocOne) {
            return new BeanPropertyAssocOne(owner, this.desc, (DeployBeanPropertyAssocOne)deployProp);
        }
        if (deployProp instanceof DeployBeanPropertySimpleCollection) {
            return new BeanPropertySimpleCollection(this.desc, (DeployBeanPropertySimpleCollection)deployProp);
        }
        if (deployProp instanceof DeployBeanPropertyAssocMany) {
            return new BeanPropertyAssocMany(this.desc, (DeployBeanPropertyAssocMany)deployProp);
        }
        if (deployProp.isJsonMapper()) {
            return new BeanPropertyJsonMapper(this.desc, deployProp);
        }
        if (deployProp.isJsonType()) {
            return new BeanPropertyJsonBasic(this.desc, deployProp);
        }
        return new BeanProperty(this.desc, deployProp);
    }

    private static class NoopSetter
    implements BeanPropertySetter {
        private NoopSetter() {
        }

        @Override
        public void set(EntityBean bean, Object value) {
        }

        @Override
        public void setIntercept(EntityBean bean, Object value) {
        }
    }

    private static enum Mode {
        Save,
        Delete;

    }
}

