/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.config.BeanNotRegisteredException;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanEmbeddedMeta;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyOverride;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import java.util.Map;
import javax.persistence.Column;

final class BeanEmbeddedMetaFactory {
    BeanEmbeddedMetaFactory() {
    }

    public static BeanEmbeddedMeta create(BeanDescriptorMap owner, DeployBeanPropertyAssocOne<?> prop) {
        BeanDescriptor targetDesc = owner.descriptor(prop.getTargetType());
        if (targetDesc == null) {
            String msg = "Could not find BeanDescriptor for " + prop.getTargetType() + ". Perhaps the EmbeddedId class is not registered? See https://ebean.io/docs/trouble-shooting#not-registered";
            throw new BeanNotRegisteredException(msg);
        }
        String columnPrefix = prop.getColumnPrefix();
        Map<String, Column> propColMap = prop.getDeployEmbedded().getPropertyColumnMap();
        BeanProperty[] sourceProperties = targetDesc.propertiesNonTransient();
        BeanProperty[] embeddedProperties = new BeanProperty[sourceProperties.length];
        for (int i = 0; i < sourceProperties.length; ++i) {
            String propertyName = sourceProperties[i].name();
            Column column = propColMap.get(propertyName);
            String dbColumn = BeanEmbeddedMetaFactory.dbColumn(columnPrefix, column, sourceProperties[i]);
            boolean dbNullable = BeanEmbeddedMetaFactory.dbNullable(column, sourceProperties[i]);
            int dbLength = BeanEmbeddedMetaFactory.dbLength(column, sourceProperties[i]);
            int dbScale = BeanEmbeddedMetaFactory.dbScale(column, sourceProperties[i]);
            String colDefn = BeanEmbeddedMetaFactory.getDbColumnDefn(column, sourceProperties[i]);
            BeanPropertyOverride overrides = new BeanPropertyOverride(dbColumn, dbNullable, dbLength, dbScale, colDefn);
            embeddedProperties[i] = sourceProperties[i].override(overrides);
        }
        return new BeanEmbeddedMeta(embeddedProperties);
    }

    private static String dbColumn(String prefix, Column override, BeanProperty source) {
        String dbCol = override != null && !override.name().isEmpty() ? override.name() : source.dbColumn();
        return prefix == null ? dbCol : prefix + dbCol;
    }

    private static boolean dbNullable(Column override, BeanProperty source) {
        return override != null ? override.nullable() : source.isNullable();
    }

    private static int dbLength(Column override, BeanProperty source) {
        return override != null && override.length() != 255 ? override.length() : source.dbLength();
    }

    private static int dbScale(Column override, BeanProperty source) {
        return override != null && override.scale() != 0 ? override.scale() : source.dbScale();
    }

    private static String getDbColumnDefn(Column override, BeanProperty source) {
        return override != null && !override.columnDefinition().isEmpty() ? override.columnDefinition() : source.dbColumnDefn();
    }
}

