/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.json;

import io.ebean.ModifyAwareType;
import io.ebeaninternal.json.ModifyAwareFlag;
import io.ebeaninternal.json.ModifyAwareIterator;
import io.ebeaninternal.json.ModifyAwareListIterator;
import io.ebeaninternal.json.ModifyAwareSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public final class ModifyAwareList<E>
implements List<E>,
ModifyAwareType,
Serializable {
    private static final long serialVersionUID = 1L;
    final List<E> list;
    final ModifyAwareType owner;

    public ModifyAwareList(List<E> list) {
        this.list = list;
        this.owner = new ModifyAwareFlag();
    }

    public ModifyAwareList(ModifyAwareType owner, List<E> list) {
        this.list = list;
        this.owner = owner;
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModifyAwareList) {
            ModifyAwareList that = (ModifyAwareList)o;
            return Objects.equals(this.list, that.list);
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        return Objects.equals(this.list, that);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean isMarkedDirty() {
        return this.owner.isMarkedDirty();
    }

    public void setMarkedDirty(boolean markedDirty) {
        this.owner.setMarkedDirty(markedDirty);
    }

    private void markAsDirty() {
        this.owner.setMarkedDirty(true);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ModifyAwareIterator<E>(this.owner, this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.markAsDirty();
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.markAsDirty();
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.markAsDirty();
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.markAsDirty();
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.markAsDirty();
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.markAsDirty();
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.markAsDirty();
        this.list.clear();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.markAsDirty();
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.markAsDirty();
        this.list.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.markAsDirty();
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ModifyAwareListIterator<E>(this.owner, this.list.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ModifyAwareListIterator<E>(this.owner, this.list.listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ModifyAwareList<E>(this.owner, this.list.subList(fromIndex, toIndex));
    }

    public ModifyAwareSet<E> asSet() {
        return new ModifyAwareSet<E>(this.owner, new LinkedHashSet<E>(this.list));
    }
}

