/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance;

import io.ebean.enhance.asm.ClassReader;
import io.ebean.enhance.asm.ClassWriterWithoutClassLoading;
import io.ebean.enhance.common.AgentManifest;
import io.ebean.enhance.common.AlreadyEnhancedException;
import io.ebean.enhance.common.ClassBytesReader;
import io.ebean.enhance.common.CommonSuperUnresolved;
import io.ebean.enhance.common.DetectEnhancement;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.NoEnhancementRequiredException;
import io.ebean.enhance.common.TransformRequest;
import io.ebean.enhance.common.UrlPathHelper;
import io.ebean.enhance.entity.ClassAdapterEntity;
import io.ebean.enhance.entity.ClassPathClassBytesReader;
import io.ebean.enhance.entity.MessageOutput;
import io.ebean.enhance.querybean.TypeQueryClassAdapter;
import io.ebean.enhance.transactional.ClassAdapterTransactional;
import io.ebean.enhance.transactional.TransactionalMethodKey;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.avaje.agentloader.AgentLoader;

public class Transformer
implements ClassFileTransformer {
    private static Instrumentation instrumentation;
    private static Transformer transformer;
    private final EnhanceContext enhanceContext;
    private final List<CommonSuperUnresolved> unresolved = new ArrayList<CommonSuperUnresolved>();
    private boolean keepUnresolved;

    public static void agentmain(String agentArgs, Instrumentation inst) {
        Transformer.premain(agentArgs, inst);
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        instrumentation = inst;
        transformer = new Transformer(null, agentArgs);
        inst.addTransformer(transformer);
    }

    public Transformer(ClassLoader classLoader, String agentArgs) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ClassPathClassBytesReader reader = new ClassPathClassBytesReader(null);
        AgentManifest manifest = AgentManifest.read(classLoader, null);
        this.enhanceContext = new EnhanceContext(reader, agentArgs, manifest);
    }

    public Transformer(EnhanceContext enhanceContext) {
        this.enhanceContext = enhanceContext;
    }

    public Transformer(ClassBytesReader bytesReader, String agentArgs, AgentManifest manifest) {
        this.enhanceContext = new EnhanceContext(bytesReader, agentArgs, manifest);
    }

    public static Instrumentation instrumentation() {
        Transformer.verifyInitialization();
        return instrumentation;
    }

    public static Transformer get() {
        Transformer.verifyInitialization();
        return transformer;
    }

    public static void verifyInitialization() {
        if (instrumentation == null && !AgentLoader.loadAgentFromClasspath((String)"ebean-agent", (String)"debug=1")) {
            throw new IllegalStateException("ebean-agent not found in classpath - not dynamically loaded");
        }
    }

    public void setKeepUnresolved() {
        this.keepUnresolved = true;
    }

    public void setLogout(MessageOutput logout) {
        this.enhanceContext.setLogout(logout);
    }

    public void log(int level, String msg) {
        this.log(level, null, msg);
    }

    private void log(int level, String className, String msg) {
        this.enhanceContext.log(level, className, msg);
    }

    public int getLogLevel() {
        return this.enhanceContext.getLogLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.enhanceContext.isIgnoreClass(className)) {
                this.log(9, className, "ignore class");
                byte[] byArray = null;
                return byArray;
            }
            TransformRequest request = new TransformRequest(className, classfileBuffer);
            if (this.enhanceContext.detectEntityTransactionalEnhancement(className)) {
                this.enhanceEntityAndTransactional(loader, request);
            }
            if (this.enhanceContext.detectQueryBeanEnhancement(className)) {
                this.enhanceQueryBean(loader, request);
            }
            if (request.isEnhanced()) {
                byte[] byArray = request.getBytes();
                return byArray;
            }
            this.log(9, className, "no enhancement on class");
            byte[] byArray = null;
            return byArray;
        }
        catch (NoEnhancementRequiredException e) {
            this.log(8, className, "No Enhancement required " + e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e) {
            if (this.enhanceContext.isThrowOnError()) {
                throw new IllegalStateException(e);
            }
            this.enhanceContext.log(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.logUnresolvedCommonSuper(className);
        }
    }

    private void enhanceEntityAndTransactional(ClassLoader loader, TransformRequest request) {
        try {
            DetectEnhancement detect = this.detect(loader, request.getBytes());
            if (detect.isEntity()) {
                if (detect.isEnhancedEntity()) {
                    detect.log(3, "already enhanced entity");
                } else {
                    this.entityEnhancement(loader, request);
                }
            }
            if (this.enhanceContext.isEnableProfileLocation() || detect.isTransactional()) {
                if (detect.isEnhancedTransactional()) {
                    detect.log(3, "already enhanced transactional");
                } else {
                    this.transactionalEnhancement(loader, request);
                }
            }
        }
        catch (NoEnhancementRequiredException e) {
            this.log(8, request.getClassName(), "No entity or transactional enhancement required " + e.getMessage());
        }
    }

    public List<TransactionalMethodKey> getTransactionProfilingKeys() {
        return this.enhanceContext.getTransactionProfilingKeys();
    }

    private void logUnresolvedCommonSuper(String className) {
        if (!this.keepUnresolved && !this.unresolved.isEmpty()) {
            for (CommonSuperUnresolved commonUnresolved : this.unresolved) {
                this.log(0, className, commonUnresolved.getMessage());
            }
            this.unresolved.clear();
        }
    }

    public List<CommonSuperUnresolved> getUnresolved() {
        return this.unresolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entityEnhancement(ClassLoader loader, TransformRequest request) {
        ClassReader cr = new ClassReader(request.getBytes());
        ClassWriterWithoutClassLoading cw = new ClassWriterWithoutClassLoading(2, loader);
        ClassAdapterEntity ca = new ClassAdapterEntity(cw, loader, this.enhanceContext);
        try {
            cr.accept(ca, 8);
            if (ca.isLog(1)) {
                ca.logEnhanced();
            }
            request.enhancedEntity(cw.toByteArray());
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(2)) {
                ca.log("already enhanced entity");
            }
            request.enhancedEntity(null);
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(3)) {
                ca.log("skipping... no enhancement required");
            }
        }
        finally {
            this.unresolved.addAll(cw.getUnresolved());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transactionalEnhancement(ClassLoader loader, TransformRequest request) {
        ClassReader cr = new ClassReader(request.getBytes());
        ClassWriterWithoutClassLoading cw = new ClassWriterWithoutClassLoading(2, loader);
        ClassAdapterTransactional ca = new ClassAdapterTransactional(cw, loader, this.enhanceContext);
        try {
            cr.accept(ca, 8);
            if (ca.isLog(1)) {
                ca.log("enhanced transactional");
            }
            request.enhancedTransactional(cw.toByteArray());
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(3)) {
                ca.log("already enhanced");
            }
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(3)) {
                ca.log("skipping... no enhancement required");
            }
        }
        finally {
            this.unresolved.addAll(cw.getUnresolved());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enhanceQueryBean(ClassLoader loader, TransformRequest request) {
        ClassReader cr = new ClassReader(request.getBytes());
        ClassWriterWithoutClassLoading cw = new ClassWriterWithoutClassLoading(2, loader);
        TypeQueryClassAdapter ca = new TypeQueryClassAdapter(cw, this.enhanceContext);
        try {
            cr.accept(ca, 8);
            if (ca.isLog(9)) {
                ca.log("... completed");
            }
            request.enhancedQueryBean(cw.toByteArray());
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(1)) {
                ca.log("already enhanced");
            }
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(9)) {
                ca.log("... skipping, no enhancement required");
            }
        }
        finally {
            this.unresolved.addAll(cw.getUnresolved());
        }
    }

    public static URL[] parseClassPaths(String extraClassPath) {
        if (extraClassPath == null) {
            return new URL[0];
        }
        return UrlPathHelper.convertToUrl(extraClassPath.split(";"));
    }

    private DetectEnhancement detect(ClassLoader classLoader, byte[] classfileBuffer) {
        DetectEnhancement detect = new DetectEnhancement(classLoader, this.enhanceContext);
        ClassReader cr = new ClassReader(classfileBuffer);
        cr.accept(detect, 7);
        return detect;
    }
}

