/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.http.client;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.http.client.HttpClient;
import io.druid.java.util.http.client.HttpClientConfig;
import io.druid.java.util.http.client.NettyHttpClient;
import io.druid.java.util.http.client.netty.HttpClientPipelineFactory;
import io.druid.java.util.http.client.pool.ChannelResourceFactory;
import io.druid.java.util.http.client.pool.ResourcePool;
import io.druid.java.util.http.client.pool.ResourcePoolConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;
import org.joda.time.Duration;

public class HttpClientInit {
    public static HttpClient createClient(HttpClientConfig config, Lifecycle lifecycle) {
        try {
            final HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Timer-%s").build(), ThreadNameDeterminer.CURRENT, 100L, TimeUnit.MILLISECONDS, 512);
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() throws Exception {
                    timer.start();
                }

                @Override
                public void stop() {
                    timer.stop();
                }
            });
            return lifecycle.addMaybeStartManagedInstance(new NettyHttpClient(new ResourcePool<String, ChannelFuture>(new ChannelResourceFactory(HttpClientInit.createBootstrap(lifecycle, (Timer)timer, config.getBossPoolSize(), config.getWorkerPoolSize()), config.getSslContext(), (Timer)timer, config.getSslHandshakeTimeout() == null ? -1L : config.getSslHandshakeTimeout().getMillis()), new ResourcePoolConfig(config.getNumConnections(), config.getUnusedConnectionTimeoutDuration().getMillis())), config.getReadTimeout(), config.getCompressionCodec(), (Timer)timer));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Deprecated
    public static HttpClient createClient(ResourcePoolConfig config, SSLContext sslContext, Lifecycle lifecycle) {
        return HttpClientInit.createClient(new HttpClientConfig(config.getMaxPerKey(), sslContext, Duration.ZERO), lifecycle);
    }

    @Deprecated
    public static ClientBootstrap createBootstrap(Lifecycle lifecycle, Timer timer) {
        HttpClientConfig defaultConfig = HttpClientConfig.builder().build();
        return HttpClientInit.createBootstrap(lifecycle, timer, defaultConfig.getBossPoolSize(), defaultConfig.getWorkerPoolSize());
    }

    @Deprecated
    public static ClientBootstrap createBootstrap(Lifecycle lifecycle) {
        HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setDaemon(true).build());
        return HttpClientInit.createBootstrap(lifecycle, (Timer)timer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLContext sslContextWithTrustedKeyStore(String keyStorePath, String keyStorePassword) {
        SSLContext sSLContext;
        FileInputStream in = null;
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            in = new FileInputStream(keyStorePath);
            ks.load(in, keyStorePassword.toCharArray());
            in.close();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            sSLContext = sslContext;
        }
        catch (CertificateException e) {
            try {
                throw Throwables.propagate((Throwable)e);
                catch (NoSuchAlgorithmException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
                catch (KeyStoreException e3) {
                    throw Throwables.propagate((Throwable)e3);
                }
                catch (KeyManagementException e4) {
                    throw Throwables.propagate((Throwable)e4);
                }
                catch (FileNotFoundException e5) {
                    throw Throwables.propagate((Throwable)e5);
                }
                catch (IOException e6) {
                    throw Throwables.propagate((Throwable)e6);
                }
            }
            catch (Throwable throwable) {
                CloseQuietly.close(in);
                throw throwable;
            }
        }
        CloseQuietly.close(in);
        return sSLContext;
    }

    private static ClientBootstrap createBootstrap(Lifecycle lifecycle, Timer timer, int bossPoolSize, int workerPoolSize) {
        NioClientBossPool bossPool = new NioClientBossPool((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Netty-Boss-%s").build()), bossPoolSize, timer, ThreadNameDeterminer.CURRENT);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Netty-Worker-%s").build()), workerPoolSize, ThreadNameDeterminer.CURRENT);
        final ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool));
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory());
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() throws Exception {
                }

                @Override
                public void stop() {
                    bootstrap.releaseExternalResources();
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return bootstrap;
    }
}

