/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata.storage.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.mysql.jdbc.exceptions.MySQLTransientException;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.metadata.storage.mysql.MySQLConnectorConfig;
import java.io.File;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.BooleanMapper;

public class MySQLConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(MySQLConnector.class);
    private static final String PAYLOAD_TYPE = "LONGBLOB";
    private static final String SERIAL_TYPE = "BIGINT(20) AUTO_INCREMENT";
    private static final String QUOTE_STRING = "`";
    private final DBI dbi;

    @Inject
    public MySQLConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, MySQLConnectorConfig connectorConfig) {
        super(config, dbTables);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName("com.mysql.jdbc.Driver");
        datasource.addConnectionProperty("useSSL", String.valueOf(connectorConfig.isUseSSL()));
        if (connectorConfig.isUseSSL()) {
            log.info("SSL is enabled on this MySQL connection. ", new Object[0]);
            datasource.addConnectionProperty("verifyServerCertificate", String.valueOf(connectorConfig.isVerifyServerCertificate()));
            if (connectorConfig.isVerifyServerCertificate()) {
                log.info("Server certificate verification is enabled. ", new Object[0]);
                if (connectorConfig.getTrustCertificateKeyStoreUrl() != null) {
                    datasource.addConnectionProperty("trustCertificateKeyStoreUrl", new File(connectorConfig.getTrustCertificateKeyStoreUrl()).toURI().toString());
                }
                if (connectorConfig.getTrustCertificateKeyStoreType() != null) {
                    datasource.addConnectionProperty("trustCertificateKeyStoreType", connectorConfig.getTrustCertificateKeyStoreType());
                }
                if (connectorConfig.getTrustCertificateKeyStorePassword() == null) {
                    log.warn("Trust store password is empty. Ensure that the trust store has been configured with an empty password.", new Object[0]);
                } else {
                    datasource.addConnectionProperty("trustCertificateKeyStorePassword", connectorConfig.getTrustCertificateKeyStorePassword());
                }
            }
            if (connectorConfig.getClientCertificateKeyStoreUrl() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStoreUrl", new File(connectorConfig.getClientCertificateKeyStoreUrl()).toURI().toString());
            }
            if (connectorConfig.getClientCertificateKeyStoreType() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStoreType", connectorConfig.getClientCertificateKeyStoreType());
            }
            if (connectorConfig.getClientCertificateKeyStorePassword() != null) {
                datasource.addConnectionProperty("clientCertificateKeyStorePassword", connectorConfig.getClientCertificateKeyStorePassword());
            }
            Joiner joiner = Joiner.on((String)",").skipNulls();
            if (connectorConfig.getEnabledSSLCipherSuites() != null) {
                datasource.addConnectionProperty("enabledSSLCipherSuites", joiner.join(connectorConfig.getEnabledSSLCipherSuites()));
            }
            if (connectorConfig.getEnabledTLSProtocols() != null) {
                datasource.addConnectionProperty("enabledTLSProtocols", joiner.join(connectorConfig.getEnabledTLSProtocols()));
            }
        }
        datasource.setConnectionInitSqls((Collection)ImmutableList.of((Object)"SET sql_mode='ANSI_QUOTES'"));
        this.dbi = new DBI((DataSource)datasource);
        log.info("Configured MySQL as metadata storage", new Object[0]);
    }

    protected String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    public String getQuoteString() {
        return QUOTE_STRING;
    }

    protected int getStreamingFetchSize() {
        return Integer.MIN_VALUE;
    }

    public boolean tableExists(Handle handle, String tableName) {
        boolean isUtf8 = (Boolean)handle.createQuery("SELECT @@character_set_database = 'utf8'").map((ResultSetMapper)BooleanMapper.FIRST).first();
        if (!isUtf8) {
            throw new ISE("Database default character set is not UTF-8." + System.lineSeparator() + "  Druid requires its MySQL database to be created using UTF-8 as default character set.", new Object[0]);
        }
        return !((Query)handle.createQuery("SHOW tables LIKE :tableName").bind("tableName", tableName)).list().isEmpty();
    }

    protected boolean connectorIsTransientException(Throwable e) {
        return e instanceof MySQLTransientException || e instanceof SQLException && ((SQLException)e).getErrorCode() == 1317;
    }

    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) throws Exception {
        return (Void)this.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON DUPLICATE KEY UPDATE %3$s = :value", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
                return null;
            }
        });
    }

    public DBI getDBI() {
        return this.dbi;
    }
}

