/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Set;

public class RendezvousHasher {
    private static final HashFunction HASH_FN = Hashing.murmur3_128();

    public <KeyType> String chooseNode(Set<String> nodeIds, byte[] key) {
        if (nodeIds.isEmpty()) {
            return null;
        }
        HashCode keyHash = HASH_FN.hashBytes(key);
        long maxHash = Long.MIN_VALUE;
        String maxNode = null;
        for (String nodeId : nodeIds) {
            HashCode nodeHash = HASH_FN.hashString((CharSequence)nodeId, Charsets.UTF_8);
            ArrayList hashes = Lists.newArrayList((Object[])new HashCode[]{nodeHash, keyHash});
            long combinedHash = Hashing.combineOrdered((Iterable)hashes).asLong();
            if (maxNode == null) {
                maxHash = combinedHash;
                maxNode = nodeId;
                continue;
            }
            if (combinedHash <= maxHash) continue;
            maxHash = combinedHash;
            maxNode = nodeId;
        }
        return maxNode;
    }
}

