/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerSelectorStrategy;

public class PriorityTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final int minPriority;
    private final int maxPriority;

    @JsonCreator
    public PriorityTieredBrokerSelectorStrategy(@JsonProperty(value="minPriority") Integer minPriority, @JsonProperty(value="maxPriority") Integer maxPriority) {
        this.minPriority = minPriority == null ? 0 : minPriority;
        this.maxPriority = maxPriority == null ? 1 : maxPriority;
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig tierConfig, Query query) {
        int priority = QueryContexts.getPriority((Query)query);
        if (priority < this.minPriority || priority > this.maxPriority) {
            return Optional.of((Object)tierConfig.getDefaultBrokerServiceName());
        }
        return Optional.absent();
    }
}

