/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.cache;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import io.druid.discovery.DiscoveryDruidNode;
import io.druid.discovery.DruidNodeDiscovery;
import io.druid.discovery.DruidNodeDiscoveryProvider;
import io.druid.discovery.LookupNodeService;
import io.druid.server.http.HostAndPortWithScheme;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class LookupNodeDiscovery {
    private final DruidNodeDiscovery druidNodeDiscovery;

    LookupNodeDiscovery(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
        this.druidNodeDiscovery = druidNodeDiscoveryProvider.getForService("lookupNodeService");
    }

    public Collection<HostAndPortWithScheme> getNodesInTier(final String tier) {
        return Collections2.transform((Collection)Collections2.filter(this.druidNodeDiscovery.getAllNodes(), (Predicate)new Predicate<DiscoveryDruidNode>(){

            public boolean apply(@Nullable DiscoveryDruidNode node) {
                return tier.equals(((LookupNodeService)node.getServices().get("lookupNodeService")).getLookupTier());
            }
        }), (Function)new Function<DiscoveryDruidNode, HostAndPortWithScheme>(){

            public HostAndPortWithScheme apply(@Nullable DiscoveryDruidNode input) {
                return HostAndPortWithScheme.fromString(input.getDruidNode().getServiceScheme(), input.getDruidNode().getHostAndPortToUse());
            }
        });
    }

    public Set<String> getAllTiers() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        this.druidNodeDiscovery.getAllNodes().stream().forEach(node -> builder.add((Object)((LookupNodeService)node.getServices().get("lookupNodeService")).getLookupTier()));
        return builder.build();
    }
}

