/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.Query;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.io.IOException;
import java.util.Map;
import org.slf4j.MDC;

public class LoggingRequestLogger
implements RequestLogger {
    private static final Logger LOG = new Logger(LoggingRequestLogger.class);
    private final ObjectMapper mapper;
    private final boolean setMDC;
    private final boolean setContextMDC;

    public LoggingRequestLogger(ObjectMapper mapper, boolean setMDC, boolean setContextMDC) {
        this.mapper = mapper;
        this.setMDC = setMDC;
        this.setContextMDC = setContextMDC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        Map mdc = MDC.getCopyOfContextMap();
        try {
            if (this.setMDC) {
                try {
                    Query query = requestLogLine.getQuery();
                    MDC.put((String)"queryId", (String)query.getId());
                    MDC.put((String)"dataSource", (String)query.getDataSource().toString());
                    MDC.put((String)"queryType", (String)query.getType());
                    MDC.put((String)"hasFilters", (String)Boolean.toString(query.hasFilters()));
                    MDC.put((String)"remoteAddr", (String)requestLogLine.getRemoteAddr());
                    MDC.put((String)"duration", (String)query.getDuration().toString());
                    MDC.put((String)"descending", (String)Boolean.toString(query.isDescending()));
                    if (this.setContextMDC) {
                        ImmutableList entries = query.getContext() == null ? ImmutableList.of() : query.getContext().entrySet();
                        for (Map.Entry entry : entries) {
                            MDC.put((String)((String)entry.getKey()), (String)(entry.getValue() == null ? "NULL" : entry.getValue().toString()));
                        }
                    }
                }
                catch (RuntimeException re) {
                    LOG.error((Throwable)re, "Error preparing MDC", new Object[0]);
                }
            }
            String line = requestLogLine.getLine(this.mapper);
            LOG.info("%s", new Object[]{line});
        }
        finally {
            if (this.setMDC) {
                if (mdc != null) {
                    MDC.setContextMap((Map)mdc);
                } else {
                    MDC.clear();
                }
            }
        }
    }

    public boolean isSetMDC() {
        return this.setMDC;
    }

    public boolean isSetContextMDC() {
        return this.setContextMDC;
    }

    public String toString() {
        return "LoggingRequestLogger{setMDC=" + this.setMDC + ", setContextMDC=" + this.setContextMDC + '}';
    }
}

