/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.common.guava.CloseQuietly;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutableDateTime;
import org.joda.time.chrono.ISOChronology;

public class FileRequestLogger
implements RequestLogger {
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService exec;
    private final File baseDir;
    private final Object lock = new Object();
    private DateTime currentDay;
    private OutputStreamWriter fileWriter;

    public FileRequestLogger(ObjectMapper objectMapper, ScheduledExecutorService exec, File baseDir) {
        this.exec = exec;
        this.objectMapper = objectMapper;
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        try {
            this.baseDir.mkdirs();
            MutableDateTime mutableDateTime = DateTimes.nowUtc().toMutableDateTime((Chronology)ISOChronology.getInstanceUTC());
            mutableDateTime.setMillisOfDay(0);
            Object object = this.lock;
            synchronized (object) {
                this.currentDay = mutableDateTime.toDateTime((Chronology)ISOChronology.getInstanceUTC());
                this.fileWriter = this.getFileWriter();
            }
            long nextDay = this.currentDay.plusDays(1).getMillis();
            Duration initialDelay = new Duration(nextDay - System.currentTimeMillis());
            ScheduledExecutors.scheduleWithFixedDelay((ScheduledExecutorService)this.exec, (Duration)initialDelay, (Duration)Duration.standardDays((long)1L), (Callable)new Callable<ScheduledExecutors.Signal>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ScheduledExecutors.Signal call() {
                    try {
                        Object object = FileRequestLogger.this.lock;
                        synchronized (object) {
                            FileRequestLogger.this.currentDay = FileRequestLogger.this.currentDay.plusDays(1);
                            CloseQuietly.close((Closeable)FileRequestLogger.this.fileWriter);
                            FileRequestLogger.this.fileWriter = FileRequestLogger.this.getFileWriter();
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                    return ScheduledExecutors.Signal.REPEAT;
                }
            });
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private OutputStreamWriter getFileWriter() throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.baseDir, this.currentDay.toString("yyyy-MM-dd'.log'")), true), Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            CloseQuietly.close((Closeable)this.fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.fileWriter.write(StringUtils.format((String)"%s%n", (Object[])new Object[]{requestLogLine.getLine(this.objectMapper)}));
            this.fileWriter.flush();
        }
    }

    public String toString() {
        return "FileRequestLogger{baseDir=" + this.baseDir + '}';
    }
}

