/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.emitter.core.Event;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceEventBuilder;
import io.druid.query.Query;
import io.druid.server.QueryStats;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import java.io.IOException;
import java.util.Map;
import org.joda.time.DateTime;

public class EmittingRequestLogger
implements RequestLogger {
    final ServiceEmitter emitter;
    final String feed;

    public EmittingRequestLogger(ServiceEmitter emitter, String feed) {
        this.emitter = emitter;
        this.feed = feed;
    }

    @Override
    public void log(RequestLogLine requestLogLine) throws IOException {
        this.emitter.emit((ServiceEventBuilder)new RequestLogEventBuilder(this.feed, requestLogLine));
    }

    public String toString() {
        return "EmittingRequestLogger{emitter=" + this.emitter + ", feed='" + this.feed + '\'' + '}';
    }

    private static class RequestLogEventBuilder
    extends ServiceEventBuilder<Event> {
        private final String feed;
        private final RequestLogLine requestLogLine;

        public RequestLogEventBuilder(String feed, RequestLogLine requestLogLine) {
            this.feed = feed;
            this.requestLogLine = requestLogLine;
        }

        public Event build(ImmutableMap<String, String> serviceDimensions) {
            return new RequestLogEvent(serviceDimensions, this.feed, this.requestLogLine);
        }
    }

    public static class RequestLogEvent
    implements Event {
        final ImmutableMap<String, String> serviceDimensions;
        final String feed;
        final RequestLogLine request;

        RequestLogEvent(ImmutableMap<String, String> serviceDimensions, String feed, RequestLogLine request) {
            this.serviceDimensions = serviceDimensions;
            this.request = request;
            this.feed = feed;
        }

        @JsonValue(value=false)
        public Map<String, Object> toMap() {
            return ImmutableMap.of();
        }

        @JsonProperty(value="feed")
        public String getFeed() {
            return this.feed;
        }

        @JsonProperty(value="timestamp")
        public DateTime getCreatedTime() {
            return this.request.getTimestamp();
        }

        @JsonProperty(value="service")
        public String getService() {
            return (String)this.serviceDimensions.get((Object)"service");
        }

        @JsonProperty(value="host")
        public String getHost() {
            return (String)this.serviceDimensions.get((Object)"host");
        }

        @JsonProperty(value="query")
        public Query getQuery() {
            return this.request.getQuery();
        }

        @JsonProperty(value="remoteAddr")
        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        @JsonProperty(value="queryStats")
        public QueryStats getQueryStats() {
            return this.request.getQueryStats();
        }

        public boolean isSafeToBuffer() {
            return true;
        }
    }
}

