/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.RequestLogLine;
import io.druid.server.log.RequestLogger;
import io.druid.server.log.RequestLoggerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="composing")
public class ComposingRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(ComposingRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private final List<RequestLoggerProvider> loggerProviders = Lists.newArrayList();

    public RequestLogger get() {
        ArrayList<RequestLogger> loggers = new ArrayList<RequestLogger>();
        for (RequestLoggerProvider loggerProvider : this.loggerProviders) {
            loggers.add((RequestLogger)loggerProvider.get());
        }
        ComposingRequestLogger logger = new ComposingRequestLogger(loggers);
        log.debug((Throwable)new Exception("Stack trace"), "Creating %s at", new Object[]{logger});
        return logger;
    }

    public static class ComposingRequestLogger
    implements RequestLogger {
        private final List<RequestLogger> loggers;

        public ComposingRequestLogger(List<RequestLogger> loggers) {
            this.loggers = loggers;
        }

        @Override
        public void log(RequestLogLine requestLogLine) throws IOException {
            Exception exception = null;
            for (RequestLogger logger : this.loggers) {
                try {
                    logger.log(requestLogLine);
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                Throwables.propagateIfInstanceOf(exception, IOException.class);
                throw Throwables.propagate(exception);
            }
        }

        public String toString() {
            return "ComposingRequestLogger{loggers=" + this.loggers + '}';
        }
    }
}

