/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization.jetty;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.druid.java.util.common.ISE;
import io.druid.server.initialization.jetty.JettyRequestLog;
import io.druid.server.initialization.jetty.ServletFilterHolder;
import java.util.Set;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class JettyServerInitUtils {
    private static final String[] GZIP_METHODS = new String[]{"GET", "POST"};

    public static GzipHandler wrapWithDefaultGzipHandler(Handler handler) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setIncludedMethods(GZIP_METHODS);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setHandler(handler);
        return gzipHandler;
    }

    public static void addExtensionFilters(ServletContextHandler handler, Injector injector) {
        Set extensionFilters = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<ServletFilterHolder>>(){}));
        for (ServletFilterHolder servletFilterHolder : extensionFilters) {
            FilterHolder holder = null;
            if (servletFilterHolder.getFilter() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilter());
            } else if (servletFilterHolder.getFilterClass() != null) {
                holder = new FilterHolder(servletFilterHolder.getFilterClass());
            } else {
                throw new ISE("Filter[%s] for path[%s] didn't have a Filter!?", new Object[]{servletFilterHolder, servletFilterHolder.getPath()});
            }
            if (servletFilterHolder.getInitParameters() != null) {
                holder.setInitParameters(servletFilterHolder.getInitParameters());
            }
            handler.addFilter(holder, servletFilterHolder.getPath(), servletFilterHolder.getDispatcherType());
        }
    }

    public static Handler getJettyRequestLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)new JettyRequestLog());
        return requestLogHandler;
    }
}

