/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http.security;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import io.druid.server.http.security.AbstractResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ForbiddenException;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceAction;
import io.druid.server.security.ResourceType;

public class StateResourceFilter
extends AbstractResourceFilter {
    @Inject
    public StateResourceFilter(AuthorizerMapper authorizerMapper) {
        super(authorizerMapper);
    }

    public ContainerRequest filter(ContainerRequest request) {
        ResourceAction resourceAction = new ResourceAction(new Resource("STATE", ResourceType.STATE), this.getAction(request));
        Access authResult = AuthorizationUtils.authorizeResourceAction(this.getReq(), resourceAction, this.getAuthorizerMapper());
        if (!authResult.isAllowed()) {
            throw new ForbiddenException(authResult.toString());
        }
        return request;
    }

    @Override
    public boolean isApplicable(String requestPath) {
        return requestPath.startsWith("druid/broker/v1") || requestPath.startsWith("druid/coordinator/v1") || requestPath.startsWith("druid/historical/v1") || requestPath.startsWith("druid/indexer/v1") || requestPath.startsWith("druid/coordinator/v1/rules") || requestPath.startsWith("druid/coordinator/v1/tiers") || requestPath.startsWith("druid/worker/v1") || requestPath.startsWith("druid/coordinator/v1/servers") || requestPath.startsWith("druid/v2") || requestPath.startsWith("status");
    }
}

