/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.client.DruidServer;
import io.druid.client.InventoryView;
import io.druid.server.http.security.StateResourceFilter;
import io.druid.timeline.DataSegment;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/servers")
@ResourceFilters(value={StateResourceFilter.class})
public class ServersResource {
    private final InventoryView serverInventoryView;

    private static Map<String, Object> makeSimpleServer(DruidServer input) {
        return new ImmutableMap.Builder().put((Object)"host", (Object)input.getHost()).put((Object)"tier", (Object)input.getTier()).put((Object)"type", (Object)input.getType().toString()).put((Object)"priority", (Object)input.getPriority()).put((Object)"currSize", (Object)input.getCurrSize()).put((Object)"maxSize", (Object)input.getMaxSize()).build();
    }

    private static Map<String, Object> makeFullServer(DruidServer input) {
        return new ImmutableMap.Builder().put((Object)"host", (Object)input.getHost()).put((Object)"maxSize", (Object)input.getMaxSize()).put((Object)"type", (Object)input.getType().toString()).put((Object)"tier", (Object)input.getTier()).put((Object)"priority", (Object)input.getPriority()).put((Object)"segments", input.getSegments()).put((Object)"currSize", (Object)input.getCurrSize()).build();
    }

    @Inject
    public ServersResource(InventoryView serverInventoryView) {
        this.serverInventoryView = serverInventoryView;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Map<String, Object>>(){

                public Map<String, Object> apply(DruidServer input) {
                    return ServersResource.makeFullServer(input);
                }
            }))).build();
        }
        if (simple != null) {
            return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, Map<String, Object>>(){

                public Map<String, Object> apply(DruidServer input) {
                    return ServersResource.makeSimpleServer(input);
                }
            }))).build();
        }
        return builder.entity((Object)Lists.newArrayList((Iterable)Iterables.transform(this.serverInventoryView.getInventory(), (Function)new Function<DruidServer, String>(){

            public String apply(DruidServer druidServer) {
                return druidServer.getHost();
            }
        }))).build();
    }

    @GET
    @Path(value="/{serverName}")
    @Produces(value={"application/json"})
    public Response getServer(@PathParam(value="serverName") String serverName, @QueryParam(value="simple") String simple) {
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (simple != null) {
            return builder.entity(ServersResource.makeSimpleServer(server)).build();
        }
        return builder.entity(ServersResource.makeFullServer(server)).build();
    }

    @GET
    @Path(value="/{serverName}/segments")
    @Produces(value={"application/json"})
    public Response getServerSegments(@PathParam(value="serverName") String serverName, @QueryParam(value="full") String full) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (full != null) {
            return builder.entity(server.getSegments().values()).build();
        }
        return builder.entity((Object)Collections2.transform(server.getSegments().values(), (Function)new Function<DataSegment, String>(){

            public String apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/{serverName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    public Response getServerSegment(@PathParam(value="serverName") String serverName, @PathParam(value="segmentId") String segmentId) {
        DruidServer server = this.serverInventoryView.getInventoryValue(serverName);
        if (server == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        DataSegment segment = server.getSegment(segmentId);
        if (segment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
    }
}

