/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.collect.Lists;
import io.druid.client.DruidDataSource;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.client.InventoryView;
import io.druid.java.util.common.ISE;
import io.druid.server.security.AuthorizationUtils;
import io.druid.server.security.AuthorizerMapper;
import io.druid.server.security.ResourceAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public interface InventoryViewUtils {
    public static Comparator<ImmutableDruidDataSource> comparingByName() {
        return Comparator.comparing(ImmutableDruidDataSource::getName);
    }

    public static SortedSet<ImmutableDruidDataSource> getDataSources(InventoryView serverInventoryView) {
        return serverInventoryView.getInventory().stream().flatMap(server -> server.getDataSources().stream()).map(DruidDataSource::toImmutableDruidDataSource).collect(() -> new TreeSet<ImmutableDruidDataSource>(InventoryViewUtils.comparingByName()), TreeSet::add, TreeSet::addAll);
    }

    public static SortedSet<ImmutableDruidDataSource> getSecuredDataSources(HttpServletRequest request, InventoryView inventoryView, AuthorizerMapper authorizerMapper) {
        if (authorizerMapper == null) {
            throw new ISE("No authorization mapper found", new Object[0]);
        }
        Iterable<ImmutableDruidDataSource> filteredResources = AuthorizationUtils.filterAuthorizedResources(request, InventoryViewUtils.getDataSources(inventoryView), datasource -> Lists.newArrayList((Object[])new ResourceAction[]{(ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)datasource.getName())}), authorizerMapper);
        TreeSet<ImmutableDruidDataSource> set = new TreeSet<ImmutableDruidDataSource>(InventoryViewUtils.comparingByName());
        filteredResources.forEach(set::add);
        return Collections.unmodifiableSortedSet(set);
    }
}

