/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.emitter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.emitter.core.Emitter;
import io.druid.java.util.emitter.core.HttpEmitterConfig;
import io.druid.java.util.emitter.core.HttpPostEmitter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.io.Closeable;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

public class HttpEmitterModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.http", HttpEmitterConfig.class);
        HttpEmitterModule.configureSsl(binder);
    }

    static void configureSsl(Binder binder) {
        SSLContext context;
        try {
            context = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        binder.bind(SSLContext.class).toProvider(Providers.of((Object)context)).in(LazySingleton.class);
    }

    static AsyncHttpClient createAsyncHttpClient(String nameFormat, String timerThreadNameFormat, @Nullable SSLContext sslContext) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setThreadFactory(Execs.makeThreadFactory((String)nameFormat)).setNettyTimer((Timer)new HashedWheelTimer(Execs.makeThreadFactory((String)timerThreadNameFormat)));
        if (sslContext != null) {
            builder.setSslContext((SslContext)new JdkSslContext(sslContext, true, ClientAuth.NONE));
        }
        return new DefaultAsyncHttpClient((AsyncHttpClientConfig)builder.build());
    }

    @Provides
    @ManageLifecycle
    @Named(value="http")
    public Emitter getEmitter(Supplier<HttpEmitterConfig> config, @Nullable SSLContext sslContext, Lifecycle lifecycle, ObjectMapper jsonMapper) {
        return new HttpPostEmitter((HttpEmitterConfig)config.get(), (AsyncHttpClient)lifecycle.addCloseableInstance((Closeable)HttpEmitterModule.createAsyncHttpClient("HttpPostEmitter-AsyncHttpClient-%d", "HttpPostEmitter-AsyncHttpClient-Timer-%d", sslContext)), jsonMapper);
    }
}

