/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.server.coordinator.rules.BroadcastDistributionRule;
import io.druid.server.coordinator.rules.Rules;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;

public class PeriodBroadcastDistributionRule
extends BroadcastDistributionRule {
    static final String TYPE = "broadcastByPeriod";
    private final Period period;
    private final List<String> colocatedDataSources;

    @JsonCreator
    public PeriodBroadcastDistributionRule(@JsonProperty(value="period") Period period, @JsonProperty(value="colocatedDataSources") List<String> colocatedDataSources) {
        this.period = period;
        this.colocatedDataSources = colocatedDataSources;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public List<String> getColocatedDataSources() {
        return this.colocatedDataSources;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.period, interval, referenceTimestamp);
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PeriodBroadcastDistributionRule that = (PeriodBroadcastDistributionRule)o;
        if (!Objects.equals(this.period, that.period)) {
            return false;
        }
        return Objects.equals(this.colocatedDataSources, that.colocatedDataSources);
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.period, this.colocatedDataSources);
    }
}

