/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.rules;

import io.druid.java.util.common.IAE;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ReplicationThrottler;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class LoadRule
implements Rule {
    private static final EmittingLogger log = new EmittingLogger(LoadRule.class);
    static final String ASSIGNED_COUNT = "assignedCount";
    static final String DROPPED_COUNT = "droppedCount";
    private final Object2IntMap<String> targetReplicants = new Object2IntOpenHashMap();
    private final Object2IntMap<String> currentReplicants = new Object2IntOpenHashMap();
    private final Map<String, ServerHolder> strategyCache = new HashMap<String, ServerHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoordinatorStats run(DruidCoordinator coordinator, DruidCoordinatorRuntimeParams params, DataSegment segment) {
        try {
            this.targetReplicants.putAll(this.getTieredReplicants());
            this.currentReplicants.putAll(params.getSegmentReplicantLookup().getClusterTiers(segment.getIdentifier()));
            CoordinatorStats stats = new CoordinatorStats();
            if (params.getAvailableSegments().contains(segment)) {
                this.assign(params, segment, stats);
            }
            this.drop(params, segment, stats);
            CoordinatorStats coordinatorStats = stats;
            return coordinatorStats;
        }
        finally {
            this.targetReplicants.clear();
            this.currentReplicants.clear();
            this.strategyCache.clear();
        }
    }

    private void assign(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats) {
        if (!this.currentReplicants.isEmpty()) {
            this.assignReplicas(params, segment, stats, null);
        } else {
            ServerHolder primaryHolderToLoad = this.assignPrimary(params, segment);
            if (primaryHolderToLoad == null) {
                return;
            }
            int numAssigned = 1;
            String tier = primaryHolderToLoad.getServer().getTier();
            numAssigned += this.assignReplicasForTier(tier, this.targetReplicants.getOrDefault((Object)tier, 0), numAssigned, params, LoadRule.createLoadQueueSizeLimitingPredicate(params).and(holder -> !holder.equals(primaryHolderToLoad)), segment);
            stats.addToTieredStat(ASSIGNED_COUNT, tier, numAssigned);
            this.assignReplicas(params, segment, stats, tier);
        }
    }

    private static Predicate<ServerHolder> createLoadQueueSizeLimitingPredicate(DruidCoordinatorRuntimeParams params) {
        int maxSegmentsInNodeLoadingQueue = params.getCoordinatorDynamicConfig().getMaxSegmentsInNodeLoadingQueue();
        if (maxSegmentsInNodeLoadingQueue <= 0) {
            return Objects::nonNull;
        }
        return s -> s != null && s.getNumberOfSegmentsInQueue() < maxSegmentsInNodeLoadingQueue;
    }

    private static List<ServerHolder> getFilteredHolders(String tier, DruidCluster druidCluster, Predicate<ServerHolder> predicate) {
        NavigableSet<ServerHolder> queue = druidCluster.getHistoricalsByTier(tier);
        if (queue == null) {
            log.makeAlert("Tier[%s] has no servers! Check your cluster configuration!", new Object[]{tier}).emit();
            return Collections.emptyList();
        }
        return queue.stream().filter(predicate).collect(Collectors.toList());
    }

    @Nullable
    private ServerHolder assignPrimary(DruidCoordinatorRuntimeParams params, DataSegment segment) {
        ServerHolder topCandidate = null;
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            String tier;
            List<ServerHolder> holders;
            int targetReplicantsInTier = entry.getIntValue();
            if (targetReplicantsInTier <= 0 || (holders = LoadRule.getFilteredHolders(tier = (String)entry.getKey(), params.getDruidCluster(), LoadRule.createLoadQueueSizeLimitingPredicate(params))).isEmpty()) continue;
            ServerHolder candidate = params.getBalancerStrategy().findNewSegmentHomeReplicator(segment, holders);
            if (candidate == null) {
                log.warn("No available [%s] servers or node capacity to assign primary segment[%s]! Expected Replicants[%d]", new Object[]{tier, segment.getIdentifier(), targetReplicantsInTier});
                continue;
            }
            this.strategyCache.put(tier, candidate);
            if (topCandidate != null && candidate.getServer().getPriority() <= topCandidate.getServer().getPriority()) continue;
            topCandidate = candidate;
        }
        if (topCandidate != null) {
            this.strategyCache.remove(topCandidate.getServer().getTier());
            topCandidate.getPeon().loadSegment(segment, null);
        }
        return topCandidate;
    }

    private void assignReplicas(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats, @Nullable String tierToSkip) {
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            String tier = (String)entry.getKey();
            if (tier.equals(tierToSkip)) continue;
            int numAssigned = this.assignReplicasForTier(tier, entry.getIntValue(), this.currentReplicants.getOrDefault((Object)tier, 0), params, LoadRule.createLoadQueueSizeLimitingPredicate(params), segment);
            stats.addToTieredStat(ASSIGNED_COUNT, tier, numAssigned);
        }
    }

    private int assignReplicasForTier(String tier, int targetReplicantsInTier, int currentReplicantsInTier, DruidCoordinatorRuntimeParams params, Predicate<ServerHolder> predicate, DataSegment segment) {
        int numToAssign = targetReplicantsInTier - currentReplicantsInTier;
        if (numToAssign <= 0) {
            return 0;
        }
        List<ServerHolder> holders = LoadRule.getFilteredHolders(tier, params.getDruidCluster(), predicate);
        if (holders.isEmpty()) {
            return 0;
        }
        ReplicationThrottler throttler = params.getReplicationManager();
        for (int numAssigned = 0; numAssigned < numToAssign; ++numAssigned) {
            if (!throttler.canCreateReplicant(tier)) {
                return numAssigned;
            }
            ServerHolder holder = this.strategyCache.remove(tier);
            if (holder == null) {
                holder = params.getBalancerStrategy().findNewSegmentHomeReplicator(segment, holders);
            }
            if (holder == null) {
                log.warn("No available [%s] servers or node capacity to assign segment[%s]! Expected Replicants[%d]", new Object[]{tier, segment.getIdentifier(), targetReplicantsInTier});
                return numAssigned;
            }
            holders.remove(holder);
            String segmentId = segment.getIdentifier();
            String holderHost = holder.getServer().getHost();
            throttler.registerReplicantCreation(tier, segmentId, holderHost);
            holder.getPeon().loadSegment(segment, () -> throttler.unregisterReplicantCreation(tier, segmentId, holderHost));
        }
        return numToAssign;
    }

    private void drop(DruidCoordinatorRuntimeParams params, DataSegment segment, CoordinatorStats stats) {
        DruidCluster druidCluster = params.getDruidCluster();
        if (this.loadingInProgress(druidCluster)) {
            return;
        }
        for (Object2IntMap.Entry entry : this.currentReplicants.object2IntEntrySet()) {
            int numDropped;
            String tier = (String)entry.getKey();
            NavigableSet<ServerHolder> holders = druidCluster.getHistoricalsByTier(tier);
            if (holders == null) {
                log.makeAlert("No holders found for tier[%s]", new Object[]{tier}).emit();
                numDropped = 0;
            } else {
                int currentReplicantsInTier = entry.getIntValue();
                int numToDrop = currentReplicantsInTier - this.targetReplicants.getOrDefault((Object)tier, 0);
                numDropped = LoadRule.dropForTier(numToDrop, holders, segment);
            }
            stats.addToTieredStat(DROPPED_COUNT, tier, numDropped);
        }
    }

    private boolean loadingInProgress(DruidCluster druidCluster) {
        for (Object2IntMap.Entry entry : this.targetReplicants.object2IntEntrySet()) {
            String tier = (String)entry.getKey();
            if (!druidCluster.hasTier(tier) || entry.getIntValue() <= this.currentReplicants.getOrDefault((Object)tier, 0)) continue;
            return true;
        }
        return false;
    }

    private static int dropForTier(int numToDrop, NavigableSet<ServerHolder> holdersInTier, DataSegment segment) {
        int numDropped = 0;
        Iterator<ServerHolder> iterator = holdersInTier.descendingIterator();
        while (numDropped < numToDrop) {
            if (!iterator.hasNext()) {
                log.warn("Wtf, holder was null?  I have no servers serving [%s]?", new Object[]{segment.getIdentifier()});
                break;
            }
            ServerHolder holder = iterator.next();
            if (!holder.isServingSegment(segment)) continue;
            holder.getPeon().dropSegment(segment, null);
            ++numDropped;
        }
        return numDropped;
    }

    protected static void validateTieredReplicants(Map<String, Integer> tieredReplicants) {
        if (tieredReplicants.size() == 0) {
            throw new IAE("A rule with empty tiered replicants is invalid", new Object[0]);
        }
        for (Map.Entry<String, Integer> entry : tieredReplicants.entrySet()) {
            if (entry.getValue() == null) {
                throw new IAE("Replicant value cannot be empty", new Object[0]);
            }
            if (entry.getValue() >= 0) continue;
            throw new IAE("Replicant value [%d] is less than 0, which is not allowed", new Object[]{entry.getValue()});
        }
    }

    public abstract Map<String, Integer> getTieredReplicants();

    public abstract int getNumReplicants(String var1);
}

