/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Lists;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.guava.Comparators;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.metadata.MetadataRuleManager;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.ReplicationThrottler;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.server.coordinator.rules.Rule;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;

public class DruidCoordinatorRuleRunner
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorRuleRunner.class);
    private static int MAX_MISSING_RULES = 10;
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public DruidCoordinatorRuleRunner(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime()), coordinator);
    }

    public DruidCoordinatorRuleRunner(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        this.replicatorThrottler.updateParams(this.coordinator.getDynamicConfigs().getReplicationThrottleLimit(), this.coordinator.getDynamicConfigs().getReplicantLifetime());
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        HashMap<String, Object> timelines = new HashMap<String, Object>();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            Object timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null) {
                timeline = new VersionedIntervalTimeline(Comparators.comparable());
                timelines.put(dataSegment.getDataSource(), timeline);
            }
            timeline.add(dataSegment.getInterval(), (Object)dataSegment.getVersion(), dataSegment.getShardSpec().createChunk((Object)dataSegment));
        }
        HashSet<DataSegment> overshadowed = new HashSet<DataSegment>();
        for (Object timeline : timelines.values()) {
            for (TimelineObjectHolder holder : timeline.findOvershadowed()) {
                for (DataSegment dataSegment : holder.getObject().payloads()) {
                    overshadowed.add(dataSegment);
                }
            }
        }
        HashSet<DataSegment> hashSet = new HashSet<DataSegment>();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            if (overshadowed.contains(dataSegment)) continue;
            hashSet.add(dataSegment);
        }
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExistingWithoutAvailableSegments().withReplicationManager(this.replicatorThrottler).withAvailableSegments(hashSet).build();
        DateTime now = DateTimes.nowUtc();
        MetadataRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        ArrayList segmentsWithMissingRules = Lists.newArrayListWithCapacity((int)MAX_MISSING_RULES);
        int missingRules = 0;
        for (DataSegment segment : paramsWithReplicationManager.getAvailableSegments()) {
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < MAX_MISSING_RULES) {
                segmentsWithMissingRules.add(segment.getIdentifier());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", (Object)missingRules).addData("segmentsWithMissingRules", (Object)segmentsWithMissingRules).emit();
        }
        return paramsWithReplicationManager.buildFromExistingWithoutAvailableSegments().withCoordinatorStats(stats).withAvailableSegments(params.getAvailableSegments()).build();
    }
}

