/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.client.ImmutableDruidServer;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Json;
import io.druid.java.util.http.client.HttpClient;
import io.druid.server.coordinator.CuratorLoadQueuePeon;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.HttpLoadQueuePeon;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.initialization.ZkPathsConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;

public class LoadQueueTaskMaster {
    private final CuratorFramework curator;
    private final ObjectMapper jsonMapper;
    private final ScheduledExecutorService peonExec;
    private final ExecutorService callbackExec;
    private final DruidCoordinatorConfig config;
    private final HttpClient httpClient;
    private final ZkPathsConfig zkPaths;

    @Inject
    public LoadQueueTaskMaster(CuratorFramework curator, @Json ObjectMapper jsonMapper, ScheduledExecutorService peonExec, ExecutorService callbackExec, DruidCoordinatorConfig config, @Global HttpClient httpClient, ZkPathsConfig zkPaths) {
        this.curator = curator;
        this.jsonMapper = jsonMapper;
        this.peonExec = peonExec;
        this.callbackExec = callbackExec;
        this.config = config;
        this.httpClient = httpClient;
        this.zkPaths = zkPaths;
    }

    public LoadQueuePeon giveMePeon(ImmutableDruidServer server) {
        if ("http".equalsIgnoreCase(this.config.getLoadQueuePeonType())) {
            return new HttpLoadQueuePeon(server.getURL(), this.jsonMapper, this.httpClient, this.config, this.peonExec, this.callbackExec);
        }
        return new CuratorLoadQueuePeon(this.curator, ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)server.getName()), this.jsonMapper, this.peonExec, this.callbackExec, this.config);
    }
}

