/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import io.druid.client.DirectDruidClient;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class DirectClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final QueryToolChestWarehouse warehouse;
    private final DirectDruidClient baseClient;

    public DirectClientQuerySegmentWalker(QueryToolChestWarehouse warehouse, DirectDruidClient baseClient) {
        this.warehouse = warehouse;
        this.baseClient = baseClient;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner(query);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner(query);
    }

    private <T> FinalizeResultsQueryRunner<T> makeRunner(Query<T> query) {
        return new FinalizeResultsQueryRunner((QueryRunner)this.baseClient, this.warehouse.getToolChest(query));
    }
}

