/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.base.Supplier;
import io.druid.data.input.Committer;
import io.druid.data.input.Firehose;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.plumber.Plumber;

public class Plumbers {
    private static final Logger log = new Logger(Plumbers.class);

    private Plumbers() {
    }

    public static void addNextRow(Supplier<Committer> committerSupplier, Firehose firehose, Plumber plumber, boolean reportParseExceptions, FireDepartmentMetrics metrics) {
        int numRows;
        InputRow inputRow;
        try {
            inputRow = firehose.nextRow();
        }
        catch (ParseException e) {
            if (reportParseExceptions) {
                throw e;
            }
            log.debug((Throwable)e, "Discarded row due to exception, considering unparseable.", new Object[0]);
            metrics.incrementUnparseable();
            return;
        }
        if (inputRow == null) {
            log.debug("Discarded null row, considering thrownAway.", new Object[0]);
            metrics.incrementThrownAway();
            return;
        }
        try {
            numRows = plumber.add(inputRow, committerSupplier);
        }
        catch (IndexSizeExceededException e) {
            throw new ISE((Throwable)e, "WTF?! Index size exceeded, this shouldn't happen. Bad Plumber!", new Object[0]);
        }
        if (numRows == -1) {
            metrics.incrementThrownAway();
            log.debug("Discarded row[%s], considering thrownAway.", new Object[]{inputRow});
            return;
        }
        metrics.incrementProcessed();
    }
}

