/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.SegmentDescriptor;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import io.druid.segment.realtime.appenderator.AppenderatorDriverMetadata;
import io.druid.segment.realtime.appenderator.BaseAppenderatorDriver;
import io.druid.segment.realtime.appenderator.SegmentAllocator;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentWithState;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StreamAppenderatorDriver
extends BaseAppenderatorDriver {
    private static final Logger log = new Logger(StreamAppenderatorDriver.class);
    private final SegmentHandoffNotifier handoffNotifier;
    private final FireDepartmentMetrics metrics;
    private final ObjectMapper objectMapper;

    public StreamAppenderatorDriver(Appenderator appenderator, SegmentAllocator segmentAllocator, SegmentHandoffNotifierFactory handoffNotifierFactory, UsedSegmentChecker usedSegmentChecker, ObjectMapper objectMapper, FireDepartmentMetrics metrics) {
        super(appenderator, segmentAllocator, usedSegmentChecker);
        this.handoffNotifier = ((SegmentHandoffNotifierFactory)Preconditions.checkNotNull((Object)handoffNotifierFactory, (Object)"handoffNotifierFactory")).createSegmentHandoffNotifier(appenderator.getDataSource());
        this.metrics = (FireDepartmentMetrics)Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object startJob() {
        this.handoffNotifier.start();
        AppenderatorDriverMetadata metadata = (AppenderatorDriverMetadata)this.objectMapper.convertValue(this.appenderator.startJob(), AppenderatorDriverMetadata.class);
        log.info("Restored metadata[%s].", new Object[]{metadata});
        if (metadata != null) {
            Map map = this.segments;
            synchronized (map) {
                Map<String, String> lastSegmentIds = metadata.getLastSegmentIds();
                Preconditions.checkState((boolean)metadata.getSegments().keySet().equals(lastSegmentIds.keySet()), (Object)"Sequences for segment states and last segment IDs are not same");
                TreeMap<String, SegmentsForSequenceBuilder> builders = new TreeMap<String, SegmentsForSequenceBuilder>();
                for (Map.Entry<String, List<SegmentWithState>> entry : metadata.getSegments().entrySet()) {
                    String sequenceName = entry.getKey();
                    SegmentsForSequenceBuilder builder2 = new SegmentsForSequenceBuilder(lastSegmentIds.get(sequenceName));
                    builders.put(sequenceName, builder2);
                    entry.getValue().forEach(builder2::add);
                }
                builders.forEach((sequence, builder) -> this.segments.put(sequence, builder.build()));
            }
            return metadata.getCallerMetadata();
        }
        return null;
    }

    public AppenderatorDriverAddResult add(InputRow row, String sequenceName, Supplier<Committer> committerSupplier, boolean skipSegmentLineageCheck, boolean allowIncrementalPersists) throws IOException {
        return this.append(row, sequenceName, committerSupplier, skipSegmentLineageCheck, allowIncrementalPersists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSegmentOut(String sequenceName, List<SegmentIdentifier> identifiers) {
        Map map = this.segments;
        synchronized (map) {
            BaseAppenderatorDriver.SegmentsForSequence activeSegmentsForSequence = (BaseAppenderatorDriver.SegmentsForSequence)this.segments.get(sequenceName);
            if (activeSegmentsForSequence == null) {
                throw new ISE("WTF?! Asked to remove segments for sequenceName[%s] which doesn't exist...", new Object[]{sequenceName});
            }
            for (SegmentIdentifier identifier : identifiers) {
                log.info("Moving segment[%s] out of active list.", new Object[]{identifier});
                long key = identifier.getInterval().getStartMillis();
                if (activeSegmentsForSequence.get(key) != null && !activeSegmentsForSequence.get(key).stream().noneMatch(segmentWithState -> {
                    if (segmentWithState.getSegmentIdentifier().equals(identifier)) {
                        segmentWithState.finishAppending();
                        return true;
                    }
                    return false;
                })) continue;
                throw new ISE("WTF?! Asked to remove segment[%s] that didn't exist...", new Object[]{identifier});
            }
        }
    }

    public Object persist(Committer committer) throws InterruptedException {
        try {
            log.info("Persisting data.", new Object[0]);
            long start = System.currentTimeMillis();
            Object commitMetadata = this.appenderator.persistAll(this.wrapCommitter(committer)).get();
            log.info("Persisted pending data in %,dms.", new Object[]{System.currentTimeMillis() - start});
            return commitMetadata;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ListenableFuture<Object> persistAsync(Committer committer) {
        return this.appenderator.persistAll(this.wrapCommitter(committer));
    }

    public ListenableFuture<SegmentsAndMetadata> publish(TransactionalSegmentPublisher publisher, Committer committer, Collection<String> sequenceNames) {
        List<SegmentIdentifier> theSegments = this.getSegmentWithStates(sequenceNames).map(SegmentWithState::getSegmentIdentifier).collect(Collectors.toList());
        ListenableFuture publishFuture = Futures.transform(this.pushInBackground(this.wrapCommitter(committer), theSegments), segmentsAndMetadata -> this.publishInBackground((SegmentsAndMetadata)segmentsAndMetadata, publisher));
        return Futures.transform((ListenableFuture)publishFuture, segmentsAndMetadata -> {
            Map map = this.segments;
            synchronized (map) {
                sequenceNames.forEach(this.segments::remove);
            }
            return segmentsAndMetadata;
        });
    }

    public ListenableFuture<SegmentsAndMetadata> registerHandoff(final SegmentsAndMetadata segmentsAndMetadata) {
        if (segmentsAndMetadata == null) {
            return Futures.immediateFuture(null);
        }
        List waitingSegmentIdList = segmentsAndMetadata.getSegments().stream().map(SegmentIdentifier::fromDataSegment).collect(Collectors.toList());
        final Object metadata = Preconditions.checkNotNull((Object)segmentsAndMetadata.getCommitMetadata(), (Object)"commitMetadata");
        if (waitingSegmentIdList.isEmpty()) {
            return Futures.immediateFuture((Object)new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), ((AppenderatorDriverMetadata)metadata).getCallerMetadata()));
        }
        log.info("Register handoff of segments: [%s]", new Object[]{waitingSegmentIdList});
        final SettableFuture resultFuture = SettableFuture.create();
        final AtomicInteger numRemainingHandoffSegments = new AtomicInteger(waitingSegmentIdList.size());
        for (final SegmentIdentifier segmentIdentifier : waitingSegmentIdList) {
            this.handoffNotifier.registerSegmentHandoffCallback(new SegmentDescriptor(segmentIdentifier.getInterval(), segmentIdentifier.getVersion(), segmentIdentifier.getShardSpec().getPartitionNum()), (Executor)MoreExecutors.sameThreadExecutor(), () -> {
                log.info("Segment[%s] successfully handed off, dropping.", new Object[]{segmentIdentifier});
                this.metrics.incrementHandOffCount();
                ListenableFuture<?> dropFuture = this.appenderator.drop(segmentIdentifier);
                Futures.addCallback(dropFuture, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(Object result) {
                        if (numRemainingHandoffSegments.decrementAndGet() == 0) {
                            log.info("Successfully handed off [%d] segments.", new Object[]{segmentsAndMetadata.getSegments().size()});
                            resultFuture.set((Object)new SegmentsAndMetadata(segmentsAndMetadata.getSegments(), ((AppenderatorDriverMetadata)metadata).getCallerMetadata()));
                        }
                    }

                    public void onFailure(Throwable e) {
                        log.warn(e, "Failed to drop segment[%s]?!", new Object[]{segmentIdentifier});
                        numRemainingHandoffSegments.decrementAndGet();
                        resultFuture.setException(e);
                    }
                });
            });
        }
        return resultFuture;
    }

    public ListenableFuture<SegmentsAndMetadata> publishAndRegisterHandoff(TransactionalSegmentPublisher publisher, Committer committer, Collection<String> sequenceNames) {
        return Futures.transform(this.publish(publisher, committer, sequenceNames), this::registerHandoff);
    }

    @Override
    public void close() {
        super.close();
        this.handoffNotifier.close();
    }

    private static class SegmentsForSequenceBuilder {
        private final NavigableMap<Long, LinkedList<SegmentWithState>> intervalToSegmentStates = new TreeMap<Long, LinkedList<SegmentWithState>>();
        private final String lastSegmentId;

        SegmentsForSequenceBuilder(String lastSegmentId) {
            this.lastSegmentId = lastSegmentId;
        }

        void add(SegmentWithState segmentWithState) {
            SegmentIdentifier identifier = segmentWithState.getSegmentIdentifier();
            LinkedList segmentsInInterval = this.intervalToSegmentStates.computeIfAbsent(identifier.getInterval().getStartMillis(), k -> new LinkedList());
            if (segmentWithState.getState() == SegmentWithState.SegmentState.APPENDING) {
                segmentsInInterval.addFirst(segmentWithState);
            } else {
                segmentsInInterval.addLast(segmentWithState);
            }
        }

        BaseAppenderatorDriver.SegmentsForSequence build() {
            return new BaseAppenderatorDriver.SegmentsForSequence(this.intervalToSegmentStates, this.lastSegmentId);
        }
    }
}

