/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata.storage.derby;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorage;
import io.druid.metadata.MetadataStorageConnectorConfig;
import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;

public class DerbyMetadataStorage
extends MetadataStorage {
    private static final Logger log = new Logger(DerbyMetadataStorage.class);
    private final NetworkServerControl server;

    @Inject
    public DerbyMetadataStorage(MetadataStorageConnectorConfig config) {
        try {
            this.server = new NetworkServerControl(InetAddress.getByName(config.getHost()), config.getPort());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void start() {
        try {
            log.info("Starting Derby Metadata Storage", new Object[0]);
            this.server.start(null);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

