/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata.storage.derby;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.MetadataStorage;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

@ManageLifecycle
public class DerbyConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(DerbyConnector.class);
    private static final String SERIAL_TYPE = "BIGINT GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
    private static final String QUOTE_STRING = "\\\"";
    private final DBI dbi;
    private final MetadataStorage storage;

    @Inject
    public DerbyConnector(MetadataStorage storage, Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        super(config, dbTables);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(this.getClass().getClassLoader());
        datasource.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
        this.dbi = new DBI((DataSource)datasource);
        this.storage = storage;
        log.info("Derby connector instantiated with metadata storage [%s].", new Object[]{this.storage.getClass().getName()});
    }

    public DerbyConnector(MetadataStorage storage, Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, DBI dbi) {
        super(config, dbTables);
        this.dbi = dbi;
        this.storage = storage;
    }

    @Override
    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)handle.createQuery("select * from SYS.SYSTABLES where tablename = :tableName").bind("tableName", StringUtils.toUpperCase((String)tableName))).list().isEmpty();
    }

    @Override
    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    @Override
    public String getQuoteString() {
        return QUOTE_STRING;
    }

    @Override
    public DBI getDBI() {
        return this.dbi;
    }

    @Override
    protected int getStreamingFetchSize() {
        return 1;
    }

    @Override
    public String getValidationQuery() {
        return "VALUES 1";
    }

    @LifecycleStart
    public void start() {
        log.info("Starting DerbyConnector...", new Object[0]);
        this.storage.start();
    }

    @LifecycleStop
    public void stop() {
        log.info("Stopping DerbyConnector...", new Object[0]);
        this.storage.stop();
    }
}

