/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.druid.client.DruidDataSource;
import io.druid.client.ImmutableDruidDataSource;
import io.druid.concurrent.LifecycleLock;
import io.druid.guice.ManageLifecycle;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.MapUtils;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.metadata.MetadataSegmentManagerConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.BaseResultSetMapper;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

@ManageLifecycle
public class SQLMetadataSegmentManager
implements MetadataSegmentManager {
    private static final Interner<DataSegment> DATA_SEGMENT_INTERNER = Interners.newWeakInterner();
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataSegmentManager.class);
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final AtomicReference<ConcurrentHashMap<String, DruidDataSource>> dataSourcesRef;
    private final SQLMetadataConnector connector;
    private volatile ListeningScheduledExecutorService exec = null;
    private volatile ListenableFuture<?> future = null;

    @Inject
    public SQLMetadataSegmentManager(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dataSourcesRef = new AtomicReference(new ConcurrentHashMap());
        this.connector = connector;
    }

    @Override
    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            return;
        }
        try {
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Execs.scheduledSingleThreaded((String)"DatabaseSegmentManager-Exec--%d"));
            Duration delay = ((MetadataSegmentManagerConfig)this.config.get()).getPollDuration().toStandardDuration();
            this.future = this.exec.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLMetadataSegmentManager.this.poll();
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "uncaught exception in segment manager polling thread", new Object[0]).emit();
                    }
                }
            }, 0L, delay.getMillis(), TimeUnit.MILLISECONDS);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @Override
    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            return;
        }
        try {
            ConcurrentHashMap<String, DruidDataSource> current;
            ConcurrentHashMap emptyMap = new ConcurrentHashMap();
            while (!this.dataSourcesRef.compareAndSet(current = this.dataSourcesRef.get(), emptyMap)) {
            }
            this.future.cancel(false);
            this.future = null;
            this.exec.shutdownNow();
            this.exec = null;
        }
        finally {
            this.lifecycleLock.exitStop();
        }
    }

    @Override
    public boolean enableDatasource(final String ds) {
        try {
            DBI dbi = this.connector.getDBI();
            VersionedIntervalTimeline<String, DataSegment> segmentTimeline = this.connector.inReadOnlyTransaction(new TransactionCallback<VersionedIntervalTimeline<String, DataSegment>>(){

                public VersionedIntervalTimeline<String, DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return (VersionedIntervalTimeline)((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource", (Object[])new Object[]{SQLMetadataSegmentManager.this.getSegmentsTable()})).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).bind("dataSource", ds)).map((ResultSetMapper)ByteArrayMapper.FIRST).fold((Object)new VersionedIntervalTimeline((Comparator)Ordering.natural()), (Folder3)new Folder3<VersionedIntervalTimeline<String, DataSegment>, byte[]>(){

                        public VersionedIntervalTimeline<String, DataSegment> fold(VersionedIntervalTimeline<String, DataSegment> timeline, byte[] payload, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                DataSegment segment = (DataSegment)DATA_SEGMENT_INTERNER.intern(SQLMetadataSegmentManager.this.jsonMapper.readValue(payload, DataSegment.class));
                                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                                return timeline;
                            }
                            catch (Exception e) {
                                throw new SQLException(e.toString());
                            }
                        }
                    });
                }
            });
            final ArrayList segments = Lists.newArrayList();
            List timelineObjectHolders = segmentTimeline.lookup(Intervals.of((String)"0000-01-01/3000-01-01"));
            for (TimelineObjectHolder objectHolder : timelineObjectHolders) {
                for (PartitionChunk partitionChunk : objectHolder.getObject()) {
                    segments.add(partitionChunk.getObject());
                }
            }
            if (segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return false;
            }
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    Batch batch = handle.createBatch();
                    for (DataSegment segment : segments) {
                        batch.add(StringUtils.format((String)"UPDATE %s SET used=true WHERE id = '%s'", (Object[])new Object[]{SQLMetadataSegmentManager.this.getSegmentsTable(), segment.getIdentifier()}));
                    }
                    batch.execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    @Override
    public boolean enableSegment(final String segmentId) {
        try {
            this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=true WHERE id = :id", (Object[])new Object[]{SQLMetadataSegmentManager.this.getSegmentsTable()})).bind("id", segmentId)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling segment %s", new Object[]{segmentId});
            return false;
        }
        return true;
    }

    @Override
    public boolean removeDatasource(String ds) {
        try {
            int removed = (Integer)this.connector.getDBI().withHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=false WHERE dataSource = :dataSource", (Object[])new Object[]{this.getSegmentsTable()})).bind("dataSource", ds)).execute());
            this.dataSourcesRef.get().remove(ds);
            if (removed == 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error removing datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    @Override
    public boolean removeSegment(String ds, String segmentID) {
        try {
            int removed = (Integer)this.connector.getDBI().withHandle(handle -> ((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET used=false WHERE id = :segmentID", (Object[])new Object[]{this.getSegmentsTable()})).bind("segmentID", segmentID)).execute());
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSourcesRef.get();
            DruidDataSource dataSource = dataSourceMap.get(ds);
            if (dataSource != null) {
                dataSource.removePartition(segmentID);
                if (dataSource.isEmpty()) {
                    dataSourceMap.remove(ds);
                }
            }
            if (removed == 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, e.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleLock.isStarted();
    }

    @Override
    @Nullable
    public ImmutableDruidDataSource getInventoryValue(String key) {
        DruidDataSource dataSource = this.dataSourcesRef.get().get(key);
        return dataSource == null ? null : dataSource.toImmutableDruidDataSource();
    }

    @Override
    public Collection<ImmutableDruidDataSource> getInventory() {
        return this.dataSourcesRef.get().values().stream().map(DruidDataSource::toImmutableDruidDataSource).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllDatasourceNames() {
        return (Collection)this.connector.getDBI().withHandle(handle -> (List)handle.createQuery(StringUtils.format((String)"SELECT DISTINCT(datasource) FROM %s", (Object[])new Object[]{this.getSegmentsTable()})).fold(new ArrayList(), (Folder3)new Folder3<List<String>, Map<String, Object>>(){

            public List<String> fold(List<String> druidDataSources, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                druidDataSources.add(MapUtils.getString(stringObjectMap, (String)"datasource"));
                return druidDataSources;
            }
        }));
    }

    @Override
    public void poll() {
        try {
            ConcurrentHashMap<String, DruidDataSource> current;
            if (!this.lifecycleLock.isStarted()) {
                return;
            }
            ConcurrentHashMap<String, DruidDataSource> newDataSources = new ConcurrentHashMap<String, DruidDataSource>();
            log.debug("Starting polling of segment table", new Object[0]);
            List<DataSegment> segments = this.connector.inReadOnlyTransaction(new TransactionCallback<List<DataSegment>>(){

                public List<DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE used=true", (Object[])new Object[]{SQLMetadataSegmentManager.this.getSegmentsTable()})).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).map((ResultSetMapper)new ResultSetMapper<DataSegment>(){

                        public DataSegment map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                            try {
                                return (DataSegment)DATA_SEGMENT_INTERNER.intern(SQLMetadataSegmentManager.this.jsonMapper.readValue(r.getBytes("payload"), DataSegment.class));
                            }
                            catch (IOException e) {
                                log.makeAlert((Throwable)e, "Failed to read segment from db.", new Object[0]).emit();
                                return null;
                            }
                        }
                    }).list();
                }
            });
            if (segments == null || segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return;
            }
            Collection segmentsFinal = Collections2.filter(segments, (Predicate)Predicates.notNull());
            log.info("Polled and found %,d segments in the database", new Object[]{segments.size()});
            for (DataSegment segment : segmentsFinal) {
                DruidDataSource shouldBeNull;
                String datasourceName = segment.getDataSource();
                DruidDataSource dataSource = (DruidDataSource)newDataSources.get(datasourceName);
                if (dataSource == null && (shouldBeNull = newDataSources.put(datasourceName, dataSource = new DruidDataSource(datasourceName, (Map<String, String>)ImmutableMap.of((Object)"created", (Object)DateTimes.nowUtc().toString())))) != null) {
                    log.warn("Just put key[%s] into dataSources and what was there wasn't null!?  It was[%s]", new Object[]{datasourceName, shouldBeNull});
                }
                if (dataSource.getSegments().contains(segment)) continue;
                dataSource.addSegment(segment);
            }
            while (!this.dataSourcesRef.compareAndSet(current = this.dataSourcesRef.get(), newDataSources)) {
            }
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Problem polling DB.", new Object[0]).emit();
        }
    }

    private String getSegmentsTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getSegmentsTable();
    }

    @Override
    public List<Interval> getUnusedSegmentIntervals(final String dataSource, final Interval interval, final int limit) {
        return this.connector.inReadOnlyTransaction(new TransactionCallback<List<Interval>>(){

            public List<Interval> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                ResultIterator iter = ((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT start, %2$send%2$s FROM %1$s WHERE dataSource = :dataSource and start >= :start and %2$send%2$s <= :end and used = false ORDER BY start, %2$send%2$s", (Object[])new Object[]{SQLMetadataSegmentManager.this.getSegmentsTable(), SQLMetadataSegmentManager.this.connector.getQuoteString()})).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).setMaxRows(limit).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).map((ResultSetMapper)new BaseResultSetMapper<Interval>(){

                    protected Interval mapInternal(int index, Map<String, Object> row) {
                        return new Interval((ReadableInstant)DateTimes.of((String)((String)row.get("start"))), (ReadableInstant)DateTimes.of((String)((String)row.get("end"))));
                    }
                }).iterator();
                ArrayList result = Lists.newArrayListWithCapacity((int)limit);
                for (int i = 0; i < limit && iter.hasNext(); ++i) {
                    try {
                        result.add(iter.next());
                        continue;
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                return result;
            }
        });
    }
}

