/*
 * Decompiled with CFR 0.152.
 */
package io.druid.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.druid.curator.CuratorModule;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.guice.AWSModule;
import io.druid.guice.AnnouncerModule;
import io.druid.guice.CoordinatorDiscoveryModule;
import io.druid.guice.DruidProcessingConfigModule;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.ExpressionModule;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.FirehoseModule;
import io.druid.guice.IndexingServiceDiscoveryModule;
import io.druid.guice.JacksonConfigManagerModule;
import io.druid.guice.JavaScriptModule;
import io.druid.guice.LifecycleModule;
import io.druid.guice.LocalDataStorageDruidModule;
import io.druid.guice.MetadataConfigModule;
import io.druid.guice.ModulesConfig;
import io.druid.guice.ParsersModule;
import io.druid.guice.ServerModule;
import io.druid.guice.ServerViewModule;
import io.druid.guice.StartupLoggingModule;
import io.druid.guice.StorageNodeModule;
import io.druid.guice.annotations.Client;
import io.druid.guice.annotations.EscalatedClient;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.guice.http.HttpClientModule;
import io.druid.guice.security.AuthenticatorModule;
import io.druid.guice.security.AuthorizerModule;
import io.druid.guice.security.DruidAuthModule;
import io.druid.guice.security.EscalatorModule;
import io.druid.initialization.DruidModule;
import io.druid.initialization.Log4jShutterDownerModule;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import io.druid.segment.writeout.SegmentWriteOutMediumModule;
import io.druid.server.emitter.EmitterModule;
import io.druid.server.initialization.AuthenticatorMapperModule;
import io.druid.server.initialization.AuthorizerMapperModule;
import io.druid.server.initialization.jetty.JettyServerModule;
import io.druid.server.metrics.MetricsModule;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final ConcurrentMap<File, URLClassLoader> loadersMap = new ConcurrentHashMap<File, URLClassLoader>();
    private static final Map<Class, Collection> extensionsMap = Maps.newHashMap();

    public static <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        Collection retVal = extensionsMap.get(clazz);
        if (retVal == null) {
            return Sets.newHashSet();
        }
        return retVal;
    }

    @VisibleForTesting
    static void clearLoadedImplementations() {
        extensionsMap.clear();
    }

    @VisibleForTesting
    static Map<File, URLClassLoader> getLoadersMap() {
        return loadersMap;
    }

    public static synchronized <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> serviceClass) {
        List modulesToLoad = new ServiceLoadingFromExtensions(config, serviceClass).implsToLoad;
        extensionsMap.put(serviceClass, modulesToLoad);
        return modulesToLoad;
    }

    public static File[] getExtensionFilesToLoad(ExtensionsConfig config) {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(config.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", new Object[]{rootExtensionsDir});
        }
        LinkedHashSet toLoad = config.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", new Object[]{extensionDir.getAbsolutePath()});
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public static File[] getHadoopDependencyFilesToLoad(List<String> hadoopDependencyCoordinates, ExtensionsConfig extensionsConfig) {
        File rootHadoopDependenciesDir = new File(extensionsConfig.getHadoopDependenciesDir());
        if (rootHadoopDependenciesDir.exists() && !rootHadoopDependenciesDir.isDirectory()) {
            throw new ISE("Root Hadoop dependencies directory [%s] is not a directory!?", new Object[]{rootHadoopDependenciesDir});
        }
        File[] hadoopDependenciesToLoad = new File[hadoopDependencyCoordinates.size()];
        int i = 0;
        for (String coordinate : hadoopDependencyCoordinates) {
            DefaultArtifact artifact = new DefaultArtifact(coordinate);
            File hadoopDependencyDir = new File(rootHadoopDependenciesDir, artifact.getArtifactId());
            File versionDir = new File(hadoopDependencyDir, artifact.getVersion());
            if (!hadoopDependencyDir.isDirectory() || !versionDir.isDirectory()) {
                throw new ISE("Hadoop dependency [%s] didn't exist!?", new Object[]{versionDir.getAbsolutePath()});
            }
            hadoopDependenciesToLoad[i++] = versionDir;
        }
        return hadoopDependenciesToLoad;
    }

    public static URLClassLoader getClassLoaderForExtension(File extension) throws MalformedURLException {
        URLClassLoader loader = (URLClassLoader)loadersMap.get(extension);
        if (loader == null) {
            Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
            URL[] urls = new URL[jars.size()];
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.info("added URL[%s]", new Object[]{url});
                urls[i++] = url;
            }
            loadersMap.putIfAbsent(extension, new URLClassLoader(urls, Initialization.class.getClassLoader()));
            loader = (URLClassLoader)loadersMap.get(extension);
        }
        return loader;
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(path).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<? extends Module> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector);
        defaultModules.addModules(new Object[]{new Log4jShutterDownerModule(), new DruidAuthModule(), new LifecycleModule(), EmitterModule.class, HttpClientModule.global(), HttpClientModule.escalatedGlobal(), new HttpClientModule("druid.broker.http", Client.class), new HttpClientModule("druid.broker.http", EscalatedClient.class), new CuratorModule(), new AnnouncerModule(), new AWSModule(), new MetricsModule(), new SegmentWriteOutMediumModule(), new ServerModule(), new DruidProcessingConfigModule(), new StorageNodeModule(), new JettyServerModule(), new ExpressionModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new IndexingServiceDiscoveryModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new FirehoseModule(), new ParsersModule(), new JavaScriptModule(), new AuthenticatorModule(), new AuthenticatorMapperModule(), new EscalatorModule(), new AuthorizerModule(), new AuthorizerMapperModule(), new StartupLoggingModule()});
        ModuleList actualModules = new ModuleList(baseInjector);
        actualModules.addModule(DruidSecondaryModule.class);
        for (Module module : modules) {
            actualModules.addModule(module);
        }
        Module intermediateModules = Modules.override((Iterable)defaultModules.getModules()).with((Iterable)actualModules.getModules());
        ModuleList moduleList = new ModuleList(baseInjector);
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (DruidModule module : Initialization.getFromExtensions(config, DruidModule.class)) {
            moduleList.addModule(module);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{intermediateModules}).with((Iterable)moduleList.getModules())});
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final ModulesConfig modulesConfig;
        private final ObjectMapper jsonMapper;
        private final ObjectMapper smileMapper;
        private final List<Module> modules;

        public ModuleList(Injector baseInjector) {
            this.baseInjector = baseInjector;
            this.modulesConfig = (ModulesConfig)baseInjector.getInstance(ModulesConfig.class);
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
            this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
            this.modules = Lists.newArrayList();
        }

        private List<Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (input instanceof DruidModule) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)this.registerJacksonModules((DruidModule)input));
                return;
            } else if (input instanceof Module) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
                if (!this.checkModuleClass((Class)input)) {
                    return;
                }
                if (DruidModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add((Module)this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                    return;
                } else {
                    if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                    this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        private boolean checkModuleClass(Class<?> moduleClass) {
            String moduleClassName = moduleClass.getCanonicalName();
            if (moduleClassName != null && this.modulesConfig.getExcludeList().contains(moduleClassName)) {
                log.info("Not loading module [%s] because it is present in excludeList", new Object[]{moduleClassName});
                return false;
            }
            return true;
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private DruidModule registerJacksonModules(DruidModule module) {
            for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
                this.jsonMapper.registerModule(jacksonModule);
                this.smileMapper.registerModule(jacksonModule);
            }
            return module;
        }
    }

    private static class ServiceLoadingFromExtensions<T> {
        private final ExtensionsConfig extensionsConfig;
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(ExtensionsConfig extensionsConfig, Class<T> serviceClass) {
            this.extensionsConfig = extensionsConfig;
            this.serviceClass = serviceClass;
            if (extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : Initialization.getExtensionFilesToLoad(this.extensionsConfig)) {
                log.info("Loading extension [%s] for class [%s]", new Object[]{extension.getName(), this.serviceClass});
                try {
                    URLClassLoader loader = Initialization.getClassLoaderForExtension(extension);
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getCanonicalName();
            if (serviceImplName == null) {
                log.warn("Implementation [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{serviceImpl.getClass().getName()});
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.info("Adding implementation [%s] for class [%s] from %s extension", new Object[]{serviceImplName, this.serviceClass, extensionType});
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }
}

