/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.util.Providers;
import io.druid.client.DruidServerConfig;
import io.druid.discovery.DataNodeService;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.NodeTypeConfig;
import io.druid.guice.annotations.Self;
import io.druid.query.DruidProcessingConfig;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.server.DruidNode;
import io.druid.server.coordination.DruidServerMetadata;
import javax.annotation.Nullable;

public class StorageNodeModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.server", DruidServerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segmentCache", SegmentLoaderConfig.class);
        binder.bind(NodeTypeConfig.class).toProvider(Providers.of(null));
        binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @LazySingleton
    public DruidServerMetadata getMetadata(@Self DruidNode node, @Nullable NodeTypeConfig nodeType, DruidServerConfig config) {
        if (nodeType == null) {
            throw new ProvisionException("Must override the binding for NodeTypeConfig if you want a DruidServerMetadata.");
        }
        return new DruidServerMetadata(node.getHostAndPortToUse(), node.getHostAndPort(), node.getHostAndTlsPort(), config.getMaxSize(), nodeType.getNodeType(), config.getTier(), config.getPriority());
    }

    @Provides
    @LazySingleton
    public DataNodeService getDataNodeService(@Nullable NodeTypeConfig nodeType, DruidServerConfig config) {
        if (nodeType == null) {
            throw new ProvisionException("Must override the binding for NodeTypeConfig if you want a DruidServerMetadata.");
        }
        return new DataNodeService(config.getTier(), config.getMaxSize(), nodeType.getNodeType(), config.getPriority());
    }
}

