/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Self;
import io.druid.initialization.DruidModule;
import io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.LinearShardSpec;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.SingleDimensionShardSpec;
import java.util.Collections;
import java.util.List;

public class ServerModule
implements DruidModule {
    public static final String ZK_PATHS_PROPERTY_BASE = "druid.zk.paths";

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)ZK_PATHS_PROPERTY_BASE, ZkPathsConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid", DruidNode.class, Self.class);
    }

    @Provides
    @LazySingleton
    public ScheduledExecutorFactory getScheduledExecutorFactory(Lifecycle lifecycle) {
        return ScheduledExecutors.createFactory((Lifecycle)lifecycle);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(SingleDimensionShardSpec.class, "single"), new NamedType(LinearShardSpec.class, "linear"), new NamedType(NumberedShardSpec.class, "numbered"), new NamedType(HashBasedNumberedShardSpec.class, "hashed")}));
    }
}

