/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.druid.client.cache.CacheConfig;
import io.druid.collections.BlockingPool;
import io.druid.collections.DummyBlockingPool;
import io.druid.collections.DummyNonBlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.BackgroundCaching;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Merging;
import io.druid.guice.annotations.Processing;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.concurrent.ExecutorServiceConfig;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.ExecutorServiceMonitor;
import io.druid.server.metrics.MetricsModule;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;

public class RouterProcessingModule
implements Module {
    private static final Logger log = new Logger(RouterProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @BackgroundCaching
    @LazySingleton
    public ExecutorService getBackgroundExecutorService(CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            log.error("numBackgroundThreads[%d] configured, that is ignored on Router", new Object[]{cacheConfig.getNumBackgroundThreads()});
        }
        return Execs.dummy();
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config) {
        if (config.getNumThreadsConfigured() != -1) {
            log.error("numThreads[%d] configured, that is ignored on Router", new Object[]{config.getNumThreadsConfigured()});
        }
        return Execs.dummy();
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool() {
        return DummyNonBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        if (config.getNumMergeBuffersConfigured() != -1) {
            log.error("numMergeBuffers[%d] configured, that is ignored on Router", new Object[]{config.getNumMergeBuffersConfigured()});
        }
        return DummyBlockingPool.instance();
    }
}

