/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import io.druid.guice.LazySingleton;
import io.druid.initialization.DruidModule;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.expression.GuiceExprMacroTable;
import io.druid.query.expression.LikeExprMacro;
import io.druid.query.expression.RegexpExtractExprMacro;
import io.druid.query.expression.TimestampCeilExprMacro;
import io.druid.query.expression.TimestampExtractExprMacro;
import io.druid.query.expression.TimestampFloorExprMacro;
import io.druid.query.expression.TimestampFormatExprMacro;
import io.druid.query.expression.TimestampParseExprMacro;
import io.druid.query.expression.TimestampShiftExprMacro;
import io.druid.query.expression.TrimExprMacro;
import java.util.List;

public class ExpressionModule
implements DruidModule {
    public static final List<Class<? extends ExprMacroTable.ExprMacro>> EXPR_MACROS = ImmutableList.builder().add(LikeExprMacro.class).add(RegexpExtractExprMacro.class).add(TimestampCeilExprMacro.class).add(TimestampExtractExprMacro.class).add(TimestampFloorExprMacro.class).add(TimestampFormatExprMacro.class).add(TimestampParseExprMacro.class).add(TimestampShiftExprMacro.class).add(TrimExprMacro.BothTrimExprMacro.class).add(TrimExprMacro.LeftTrimExprMacro.class).add(TrimExprMacro.RightTrimExprMacro.class).build();

    public void configure(Binder binder) {
        binder.bind(ExprMacroTable.class).to(GuiceExprMacroTable.class).in(LazySingleton.class);
        for (Class<? extends ExprMacroTable.ExprMacro> exprMacroClass : EXPR_MACROS) {
            ExpressionModule.addExprMacro(binder, exprMacroClass);
        }
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of();
    }

    public static void addExprMacro(Binder binder, Class<? extends ExprMacroTable.ExprMacro> clazz) {
        Multibinder.newSetBinder((Binder)binder, ExprMacroTable.ExprMacro.class).addBinding().to(clazz);
    }
}

