/*
 * Decompiled with CFR 0.152.
 */
package io.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.discovery.DruidService;
import io.druid.server.coordination.ServerType;
import java.util.Objects;

public class DataNodeService
extends DruidService {
    public static final String DISCOVERY_SERVICE_KEY = "dataNodeService";
    private final String tier;
    private final long maxSize;
    private final ServerType type;
    private final int priority;

    @JsonCreator
    public DataNodeService(@JsonProperty(value="tier") String tier, @JsonProperty(value="maxSize") long maxSize, @JsonProperty(value="type") ServerType type, @JsonProperty(value="priority") int priority) {
        this.tier = tier;
        this.maxSize = maxSize;
        this.type = type;
        this.priority = priority;
    }

    @Override
    public String getName() {
        return DISCOVERY_SERVICE_KEY;
    }

    @JsonProperty
    public String getTier() {
        return this.tier;
    }

    @JsonProperty
    public long getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    public ServerType getType() {
        return this.type;
    }

    @JsonProperty
    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNodeService that = (DataNodeService)o;
        return this.maxSize == that.maxSize && this.priority == that.priority && Objects.equals(this.tier, that.tier) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tier, this.maxSize, this.type, this.priority});
    }

    public String toString() {
        return "DataNodeService{tier='" + this.tier + '\'' + ", maxSize=" + this.maxSize + ", type=" + (Object)((Object)this.type) + ", priority=" + this.priority + '}';
    }
}

