/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.Maps;
import io.druid.client.selector.AbstractTierSelectorStrategy;
import io.druid.client.selector.CustomTierSelectorStrategyConfig;
import io.druid.client.selector.ServerSelectorStrategy;
import java.util.Comparator;
import java.util.HashMap;

public class CustomTierSelectorStrategy
extends AbstractTierSelectorStrategy {
    private final Comparator<Integer> comparator;

    @JsonCreator
    public CustomTierSelectorStrategy(@JacksonInject ServerSelectorStrategy serverSelectorStrategy, @JacksonInject CustomTierSelectorStrategyConfig config) {
        super(serverSelectorStrategy);
        HashMap lookup = Maps.newHashMap();
        int pos = 0;
        for (Integer integer : config.getPriorities()) {
            lookup.put(integer, pos);
            ++pos;
        }
        this.comparator = Comparator.comparingInt(lookup::get);
    }

    @Override
    public Comparator<Integer> getComparator() {
        return this.comparator;
    }
}

