/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.Execs;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public enum CacheExecutorFactory {
    COMMON_FJP{

        @Override
        public Executor createExecutor() {
            return ForkJoinPool.commonPool();
        }
    }
    ,
    SINGLE_THREAD{

        @Override
        public Executor createExecutor() {
            return Execs.singleThreaded((String)"CaffeineWorker-%s");
        }
    }
    ,
    SAME_THREAD{

        @Override
        public Executor createExecutor() {
            return Runnable::run;
        }
    };


    public abstract Executor createExecutor();

    @JsonCreator
    public static CacheExecutorFactory from(String str) {
        return Enum.valueOf(CacheExecutorFactory.class, StringUtils.toUpperCase((String)str));
    }
}

