/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.google.common.collect.Lists;
import io.druid.client.TimelineServerView;
import io.druid.client.selector.ServerSelector;
import io.druid.query.DataSource;
import io.druid.query.LocatedSegmentDescriptor;
import io.druid.query.SegmentDescriptor;
import io.druid.query.TableDataSource;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.TimelineLookup;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.partition.PartitionChunk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.Interval;

public class ServerViewUtil {
    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, String datasource, List<Interval> intervals, int numCandidates) {
        return ServerViewUtil.getTargetLocations(serverView, (DataSource)new TableDataSource(datasource), intervals, numCandidates);
    }

    public static List<LocatedSegmentDescriptor> getTargetLocations(TimelineServerView serverView, DataSource datasource, List<Interval> intervals, int numCandidates) {
        TimelineLookup<String, ServerSelector> timeline = serverView.getTimeline(datasource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList located = Lists.newArrayList();
        for (Interval interval : intervals) {
            for (TimelineObjectHolder holder : timeline.lookup(interval)) {
                for (PartitionChunk chunk : holder.getObject()) {
                    ServerSelector selector = (ServerSelector)chunk.getObject();
                    SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    long size = selector.getSegment().getSize();
                    List<DruidServerMetadata> candidates = selector.getCandidates(numCandidates);
                    located.add(new LocatedSegmentDescriptor(descriptor, size, candidates));
                }
            }
        }
        return located;
    }
}

