/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.updater;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import io.druid.indexer.JobHelper;
import io.druid.indexer.hadoop.DatasourceInputSplit;
import io.druid.indexer.hadoop.WindowedDataSegment;
import io.druid.indexer.updater.HadoopDruidConverterConfig;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;

public class HadoopConverterJob {
    private static final Logger log = new Logger(HadoopConverterJob.class);
    private static final String COUNTER_GROUP = "Hadoop Druid Converter";
    private static final String COUNTER_LOADED = "Loaded Bytes";
    private static final String COUNTER_WRITTEN = "Written Bytes";
    private final HadoopDruidConverterConfig converterConfig;
    private long loadedBytes = 0L;
    private long writtenBytes = 0L;

    private static void setJobName(JobConf jobConf, List<DataSegment> segments) {
        if (segments.size() == 1) {
            DataSegment segment = segments.get(0);
            jobConf.setJobName(StringUtils.format((String)"druid-convert-%s-%s-%s", (Object[])new Object[]{segment.getDataSource(), segment.getInterval(), segment.getVersion()}));
        } else {
            HashSet dataSources = Sets.newHashSet((Iterable)Iterables.transform(segments, (Function)new Function<DataSegment, String>(){

                public String apply(DataSegment input) {
                    return input.getDataSource();
                }
            }));
            HashSet versions = Sets.newHashSet((Iterable)Iterables.transform(segments, (Function)new Function<DataSegment, String>(){

                public String apply(DataSegment input) {
                    return input.getVersion();
                }
            }));
            jobConf.setJobName(StringUtils.format((String)"druid-convert-%s-%s", (Object[])new Object[]{Arrays.toString(dataSources.toArray()), Arrays.toString(versions.toArray())}));
        }
    }

    public static Path getJobPath(JobID jobID, Path workingDirectory) {
        return new Path(workingDirectory, jobID.toString());
    }

    public static Path getTaskPath(JobID jobID, TaskAttemptID taskAttemptID, Path workingDirectory) {
        return new Path(HadoopConverterJob.getJobPath(jobID, workingDirectory), taskAttemptID.toString());
    }

    public static Path getJobClassPathDir(String jobName, Path workingDirectory) throws IOException {
        return new Path(workingDirectory, jobName.replace(":", ""));
    }

    public static void cleanup(Job job) throws IOException {
        Path jobDir = HadoopConverterJob.getJobPath(job.getJobID(), job.getWorkingDirectory());
        FileSystem fs = jobDir.getFileSystem(job.getConfiguration());
        RuntimeException e = null;
        try {
            JobHelper.deleteWithRetry(fs, jobDir, true);
        }
        catch (RuntimeException ex) {
            e = ex;
        }
        try {
            JobHelper.deleteWithRetry(fs, HadoopConverterJob.getJobClassPathDir(job.getJobName(), job.getWorkingDirectory()), true);
        }
        catch (RuntimeException ex) {
            if (e == null) {
                e = ex;
            }
            e.addSuppressed(ex);
        }
        if (e != null) {
            throw e;
        }
    }

    public static HadoopDruidConverterConfig converterConfigFromConfiguration(Configuration configuration) throws IOException {
        String property = (String)Preconditions.checkNotNull((Object)configuration.get("io.druid.indexer.updater.converter"), (Object)"io.druid.indexer.updater.converter");
        return HadoopDruidConverterConfig.fromString(property);
    }

    public static void converterConfigIntoConfiguration(HadoopDruidConverterConfig priorConfig, List<DataSegment> segments, Configuration configuration) {
        HadoopDruidConverterConfig config = new HadoopDruidConverterConfig(priorConfig.getDataSource(), priorConfig.getInterval(), priorConfig.getIndexSpec(), segments, priorConfig.isValidate(), priorConfig.getDistributedSuccessCache(), priorConfig.getHadoopProperties(), priorConfig.getJobPriority(), priorConfig.getSegmentOutputPath());
        try {
            configuration.set("io.druid.indexer.updater.converter", HadoopDruidConverterConfig.jsonMapper.writeValueAsString((Object)config));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HadoopConverterJob(HadoopDruidConverterConfig converterConfig) {
        this.converterConfig = converterConfig;
    }

    public List<DataSegment> run() throws IOException {
        ImmutableList returnList;
        Path jobDir;
        Throwable throwable;
        Job job;
        List<DataSegment> segments;
        block30: {
            ArrayList<Path> goodPaths;
            FileSystem fs;
            block29: {
                LocatedFileStatus locatedFileStatus;
                block28: {
                    JobConf jobConf = new JobConf();
                    jobConf.setKeepFailedTaskFiles(false);
                    for (Map.Entry<String, String> entry : this.converterConfig.getHadoopProperties().entrySet()) {
                        jobConf.set(entry.getKey(), entry.getValue(), "converterConfig.getHadoopProperties()");
                    }
                    segments = this.converterConfig.getSegments();
                    if (segments.isEmpty()) {
                        throw new IAE("No segments found for datasource [%s]", new Object[]{this.converterConfig.getDataSource()});
                    }
                    HadoopConverterJob.converterConfigIntoConfiguration(this.converterConfig, segments, (Configuration)jobConf);
                    jobConf.setNumReduceTasks(0);
                    jobConf.setWorkingDirectory(new Path(this.converterConfig.getDistributedSuccessCache()));
                    HadoopConverterJob.setJobName(jobConf, segments);
                    if (this.converterConfig.getJobPriority() != null) {
                        jobConf.setJobPriority(JobPriority.valueOf((String)this.converterConfig.getJobPriority()));
                    }
                    job = Job.getInstance((Configuration)jobConf);
                    job.setInputFormatClass(ConfigInputFormat.class);
                    job.setMapperClass(ConvertingMapper.class);
                    job.setMapOutputKeyClass(Text.class);
                    job.setMapOutputValueClass(Text.class);
                    job.setMapSpeculativeExecution(false);
                    job.setOutputFormatClass(ConvertingOutputFormat.class);
                    JobHelper.setupClasspath(JobHelper.distributedClassPath(jobConf.getWorkingDirectory()), JobHelper.distributedClassPath(HadoopConverterJob.getJobClassPathDir(job.getJobName(), jobConf.getWorkingDirectory())), job);
                    throwable = null;
                    job.submit();
                    log.info("Job %s submitted, status available at %s", new Object[]{job.getJobName(), job.getTrackingURL()});
                    boolean success = job.waitForCompletion(true);
                    if (success) break block28;
                    TaskReport[] reports = job.getTaskReports(TaskType.MAP);
                    if (reports != null) {
                        for (TaskReport report : reports) {
                            log.error("Error in task [%s] : %s", new Object[]{report.getTaskId(), Arrays.toString(report.getDiagnostics())});
                        }
                    }
                    TaskReport[] taskReportArray = null;
                    try {
                        HadoopConverterJob.cleanup(job);
                    }
                    catch (IOException e) {
                        if (throwable != null) {
                            throwable.addSuppressed(e);
                        }
                        log.error((Throwable)e, "Could not clean up job [%s]", new Object[]{job.getJobID()});
                    }
                    return taskReportArray;
                }
                try {
                    this.loadedBytes = job.getCounters().findCounter(COUNTER_GROUP, COUNTER_LOADED).getValue();
                    this.writtenBytes = job.getCounters().findCounter(COUNTER_GROUP, COUNTER_WRITTEN).getValue();
                }
                catch (IOException ex) {
                    log.error((Throwable)ex, "Could not fetch counters", new Object[0]);
                }
                JobID jobID = job.getJobID();
                jobDir = HadoopConverterJob.getJobPath(jobID, job.getWorkingDirectory());
                fs = jobDir.getFileSystem(job.getConfiguration());
                RemoteIterator it = fs.listFiles(jobDir, true);
                goodPaths = new ArrayList<Path>();
                while (it.hasNext()) {
                    Path myPath;
                    locatedFileStatus = (LocatedFileStatus)it.next();
                    if (!locatedFileStatus.isFile() || !"_SUCCESS".equals((myPath = locatedFileStatus.getPath()).getName())) continue;
                    goodPaths.add(new Path(myPath.getParent(), "result"));
                }
                if (!goodPaths.isEmpty()) break block29;
                log.warn("No good data found at [%s]", new Object[]{jobDir});
                locatedFileStatus = null;
                try {
                    HadoopConverterJob.cleanup(job);
                }
                catch (IOException e) {
                    if (throwable != null) {
                        throwable.addSuppressed(e);
                    }
                    log.error((Throwable)e, "Could not clean up job [%s]", new Object[]{job.getJobID()});
                }
                return locatedFileStatus;
            }
            returnList = ImmutableList.copyOf((Collection)Lists.transform(goodPaths, (Function)new Function<Path, DataSegment>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Nullable
                public DataSegment apply(Path input) {
                    try {
                        if (!fs.exists(input)) {
                            throw new ISE("Somehow [%s] was found but [%s] is missing at [%s]", new Object[]{"_SUCCESS", "result", jobDir});
                        }
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    try (FSDataInputStream stream = fs.open(input);){
                        DataSegment dataSegment = (DataSegment)HadoopDruidConverterConfig.jsonMapper.readValue((InputStream)stream, DataSegment.class);
                        return dataSegment;
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }));
            if (returnList.size() != segments.size()) break block30;
            ImmutableList immutableList = returnList;
            try {
                HadoopConverterJob.cleanup(job);
            }
            catch (IOException e) {
                if (throwable != null) {
                    throwable.addSuppressed(e);
                }
                log.error((Throwable)e, "Could not clean up job [%s]", new Object[]{job.getJobID()});
            }
            return immutableList;
        }
        try {
            try {
                throw new ISE("Tasks reported success but result length did not match! Expected %d found %d at path [%s]", new Object[]{segments.size(), returnList.size(), jobDir});
            }
            catch (ClassNotFoundException | InterruptedException e) {
                RuntimeException exception = Throwables.propagate((Throwable)e);
                throwable = exception;
                throw exception;
            }
            catch (Throwable t) {
                throwable = t;
                throw t;
            }
        }
        catch (Throwable throwable2) {
            block31: {
                try {
                    HadoopConverterJob.cleanup(job);
                }
                catch (IOException e) {
                    if (throwable != null) {
                        throwable.addSuppressed(e);
                        break block31;
                    }
                    log.error((Throwable)e, "Could not clean up job [%s]", new Object[]{job.getJobID()});
                }
            }
            throw throwable2;
        }
    }

    public long getLoadedBytes() {
        return this.loadedBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public static class ConfigInputFormat
    extends InputFormat<String, String> {
        public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
            HadoopDruidConverterConfig config = HadoopConverterJob.converterConfigFromConfiguration(jobContext.getConfiguration());
            List<DataSegment> segments = config.getSegments();
            if (segments == null) {
                throw new IOException("Bad config, missing segments");
            }
            return Lists.transform(segments, (Function)new Function<DataSegment, InputSplit>(){

                @Nullable
                public InputSplit apply(DataSegment input) {
                    return new DatasourceInputSplit((List<WindowedDataSegment>)ImmutableList.of((Object)WindowedDataSegment.of(input)), null);
                }
            });
        }

        public RecordReader<String, String> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            return new RecordReader<String, String>(){
                boolean readAnything = false;

                public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return !this.readAnything;
                }

                public String getCurrentKey() throws IOException, InterruptedException {
                    return "key";
                }

                public String getCurrentValue() throws IOException, InterruptedException {
                    this.readAnything = true;
                    return "fakeValue";
                }

                public float getProgress() throws IOException, InterruptedException {
                    return this.readAnything ? 0.0f : 1.0f;
                }

                public void close() throws IOException {
                }
            };
        }
    }

    public static class ConvertingMapper
    extends Mapper<String, String, Text, Text> {
        private static final Logger log = new Logger(ConvertingMapper.class);
        private static final String TMP_FILE_LOC_KEY = "io.druid.indexer.updater.converter.reducer.tmpDir";

        protected void map(String key, String value, Mapper.Context context) throws IOException, InterruptedException {
            InputSplit split = context.getInputSplit();
            if (!(split instanceof DatasourceInputSplit)) {
                throw new IAE("Unexpected split type. Expected [%s] was [%s]", new Object[]{DatasourceInputSplit.class.getCanonicalName(), split.getClass().getCanonicalName()});
            }
            String tmpDirLoc = context.getConfiguration().get(TMP_FILE_LOC_KEY);
            File tmpDir = Paths.get(tmpDirLoc, new String[0]).toFile();
            DataSegment segment = ((WindowedDataSegment)Iterables.getOnlyElement(((DatasourceInputSplit)split).getSegments())).getSegment();
            HadoopDruidConverterConfig config = HadoopConverterJob.converterConfigFromConfiguration(context.getConfiguration());
            context.setStatus("DOWNLOADING");
            context.progress();
            Path inPath = new Path(JobHelper.getURIFromSegment(segment));
            File inDir = new File(tmpDir, "in");
            if (inDir.exists() && !inDir.delete()) {
                log.warn("Could not delete [%s]", new Object[]{inDir});
            }
            if (!(inDir.mkdir() || inDir.exists() && !inDir.isDirectory())) {
                log.warn("Unable to make directory", new Object[0]);
            }
            long inSize = JobHelper.unzipNoGuava(inPath, context.getConfiguration(), inDir, (Progressable)context);
            log.debug("Loaded %d bytes into [%s] for converting", new Object[]{inSize, inDir.getAbsolutePath()});
            context.getCounter(HadoopConverterJob.COUNTER_GROUP, HadoopConverterJob.COUNTER_LOADED).increment(inSize);
            context.setStatus("CONVERTING");
            context.progress();
            File outDir = new File(tmpDir, "out");
            FileUtils.forceMkdir((File)outDir);
            try {
                HadoopDruidConverterConfig.INDEX_MERGER.convert(inDir, outDir, config.getIndexSpec(), JobHelper.progressIndicatorForContext((TaskAttemptContext)context), null);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Conversion failed.", new Object[0]);
                throw e;
            }
            if (config.isValidate()) {
                context.setStatus("Validating");
                HadoopDruidConverterConfig.INDEX_IO.validateTwoSegments(inDir, outDir);
            }
            context.progress();
            context.setStatus("Starting PUSH");
            Path baseOutputPath = new Path(config.getSegmentOutputPath());
            FileSystem outputFS = baseOutputPath.getFileSystem(context.getConfiguration());
            DataSegment finalSegmentTemplate = segment.withVersion(segment.getVersion() + "_converted");
            DataSegment finalSegment = JobHelper.serializeOutIndex(finalSegmentTemplate, context.getConfiguration(), (Progressable)context, outDir, JobHelper.makeFileNamePath(baseOutputPath, outputFS, finalSegmentTemplate, "index.zip", HadoopDruidConverterConfig.DATA_SEGMENT_PUSHER), JobHelper.makeFileNamePath(baseOutputPath, outputFS, finalSegmentTemplate, "descriptor.json", HadoopDruidConverterConfig.DATA_SEGMENT_PUSHER), JobHelper.makeTmpPath(baseOutputPath, outputFS, finalSegmentTemplate, context.getTaskAttemptID(), HadoopDruidConverterConfig.DATA_SEGMENT_PUSHER), HadoopDruidConverterConfig.DATA_SEGMENT_PUSHER);
            context.progress();
            context.setStatus("Finished PUSH");
            String finalSegmentString = HadoopDruidConverterConfig.jsonMapper.writeValueAsString((Object)finalSegment);
            context.getConfiguration().set("io.druid.indexer.updater.converter.publishedSegment", finalSegmentString);
            context.write((Object)new Text("dataSegment"), (Object)new Text(finalSegmentString));
            context.getCounter(HadoopConverterJob.COUNTER_GROUP, HadoopConverterJob.COUNTER_WRITTEN).increment(finalSegment.getSize());
            context.progress();
            context.setStatus("Ready To Commit");
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            File tmpFile = Files.createTempDir();
            context.getConfiguration().set(TMP_FILE_LOC_KEY, tmpFile.getAbsolutePath());
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            String tmpDirLoc = context.getConfiguration().get(TMP_FILE_LOC_KEY);
            File tmpDir = Paths.get(tmpDirLoc, new String[0]).toFile();
            FileUtils.deleteDirectory((File)tmpDir);
            context.progress();
            context.setStatus("Clean");
        }
    }

    public static class ConvertingOutputFormat
    extends OutputFormat<Text, Text> {
        protected static final String DATA_FILE_KEY = "result";
        protected static final String DATA_SUCCESS_KEY = "_SUCCESS";
        protected static final String PUBLISHED_SEGMENT_KEY = "io.druid.indexer.updater.converter.publishedSegment";
        private static final Logger log = new Logger(ConvertingOutputFormat.class);

        public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return new RecordWriter<Text, Text>(){

                public void write(Text key, Text value) throws IOException, InterruptedException {
                }

                public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                }
            };
        }

        public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        }

        public OutputCommitter getOutputCommitter(final TaskAttemptContext context) throws IOException, InterruptedException {
            return new OutputCommitter(){

                public void setupJob(JobContext jobContext) throws IOException {
                }

                public void setupTask(TaskAttemptContext taskContext) throws IOException {
                }

                public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
                    return taskContext.getConfiguration().get(ConvertingOutputFormat.PUBLISHED_SEGMENT_KEY) != null;
                }

                public void commitTask(final TaskAttemptContext taskContext) throws IOException {
                    Progressable commitProgressable = new Progressable(){

                        public void progress() {
                            taskContext.progress();
                        }
                    };
                    String finalSegmentString = taskContext.getConfiguration().get(ConvertingOutputFormat.PUBLISHED_SEGMENT_KEY);
                    if (finalSegmentString == null) {
                        throw new IOException("Could not read final segment");
                    }
                    DataSegment newSegment = (DataSegment)HadoopDruidConverterConfig.jsonMapper.readValue(finalSegmentString, DataSegment.class);
                    log.info("Committing new segment [%s]", new Object[]{newSegment});
                    taskContext.progress();
                    FileSystem fs = taskContext.getWorkingDirectory().getFileSystem(taskContext.getConfiguration());
                    Path taskAttemptDir = HadoopConverterJob.getTaskPath(context.getJobID(), context.getTaskAttemptID(), taskContext.getWorkingDirectory());
                    Path taskAttemptFile = new Path(taskAttemptDir, ConvertingOutputFormat.DATA_FILE_KEY);
                    Path taskAttemptSuccess = new Path(taskAttemptDir, ConvertingOutputFormat.DATA_SUCCESS_KEY);
                    try (FSDataOutputStream outputStream = fs.create(taskAttemptFile, false, 1024, commitProgressable);){
                        outputStream.write(HadoopDruidConverterConfig.jsonMapper.writeValueAsBytes((Object)newSegment));
                    }
                    fs.create(taskAttemptSuccess, false).close();
                    taskContext.progress();
                    taskContext.setStatus("Committed");
                }

                public void abortTask(TaskAttemptContext taskContext) throws IOException {
                    log.warn("Aborting task. Nothing to clean up.", new Object[0]);
                }
            };
        }
    }
}

