/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.hadoop.FSSpideringIterator;
import io.druid.indexer.path.GranularityPathSpec;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Comparators;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GranularUnprocessedPathSpec
extends GranularityPathSpec {
    private int maxBuckets;

    @JsonProperty
    public int getMaxBuckets() {
        return this.maxBuckets;
    }

    public void setMaxBuckets(int maxBuckets) {
        this.maxBuckets = maxBuckets;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        long mTime;
        Preconditions.checkState((boolean)(config.getGranularitySpec() instanceof UniformGranularitySpec), (Object)StringUtils.format((String)"Cannot use %s without %s", (Object[])new Object[]{GranularUnprocessedPathSpec.class.getSimpleName(), UniformGranularitySpec.class.getSimpleName()}));
        Path betaInput = new Path(this.getInputPath());
        FileSystem fs = betaInput.getFileSystem(job.getConfiguration());
        Granularity segmentGranularity = config.getGranularitySpec().getSegmentGranularity();
        TreeMap<Long, Long> inputModifiedTimes = new TreeMap<Long, Long>((Comparator<Long>)Ordering.natural().reverse());
        for (FileStatus status : FSSpideringIterator.spiderIterable(fs, betaInput)) {
            DateTime key = segmentGranularity.toDate(status.getPath().toString());
            Long currVal = (Long)inputModifiedTimes.get(key.getMillis());
            mTime = status.getModificationTime();
            inputModifiedTimes.put(key.getMillis(), currVal == null ? mTime : Math.max(currVal, mTime));
        }
        TreeSet bucketsToRun = Sets.newTreeSet((Comparator)Comparators.intervals());
        for (Map.Entry entry : inputModifiedTimes.entrySet()) {
            DateTime timeBucket = DateTimes.utc((long)((Long)entry.getKey()));
            mTime = (Long)entry.getValue();
            String bucketOutput = StringUtils.format((String)"%s/%s", (Object[])new Object[]{config.getSchema().getIOConfig().getSegmentOutputPath(), segmentGranularity.toPath(timeBucket)});
            for (FileStatus fileStatus : FSSpideringIterator.spiderIterable(fs, new Path(bucketOutput))) {
                if (fileStatus.getModificationTime() <= mTime) continue;
                bucketsToRun.add(new Interval((ReadableInstant)timeBucket, (ReadableInstant)segmentGranularity.increment(timeBucket)));
                break;
            }
            if (bucketsToRun.size() < this.maxBuckets) continue;
            break;
        }
        config.setGranularitySpec((GranularitySpec)new UniformGranularitySpec(segmentGranularity, config.getGranularitySpec().getQueryGranularity(), Boolean.valueOf(config.getGranularitySpec().isRollup()), (List)Lists.newArrayList((Iterable)bucketsToRun)));
        return super.addInputPaths(config, job);
    }
}

