/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.druid.indexer.DetermineHashedPartitionsJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.Jobby;
import io.druid.indexer.partitions.AbstractPartitionsSpec;
import java.util.List;
import javax.annotation.Nullable;

public class HashedPartitionsSpec
extends AbstractPartitionsSpec {
    private static final List<String> DEFAULT_PARTITION_DIMENSIONS = ImmutableList.of();
    @JsonIgnore
    private final List<String> partitionDimensions;

    public static HashedPartitionsSpec makeDefaultHashedPartitionsSpec() {
        return new HashedPartitionsSpec(null, null, null, null, null);
    }

    @JsonCreator
    public HashedPartitionsSpec(@JsonProperty(value="targetPartitionSize") @Nullable Long targetPartitionSize, @JsonProperty(value="maxPartitionSize") @Nullable Long maxPartitionSize, @JsonProperty(value="assumeGrouped") @Nullable Boolean assumeGrouped, @JsonProperty(value="numShards") @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions) {
        super(targetPartitionSize, maxPartitionSize, assumeGrouped, numShards);
        this.partitionDimensions = partitionDimensions == null ? DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
    }

    @Override
    public Jobby getPartitionJob(HadoopDruidIndexerConfig config) {
        return new DetermineHashedPartitionsJob(config);
    }

    @Override
    @JsonProperty
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }
}

