/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.druid.indexer.updater.MetadataStorageUpdaterJobSpec;
import io.druid.segment.indexing.IOConfig;
import java.util.Map;

@JsonTypeName(value="hadoop")
public class HadoopIOConfig
implements IOConfig {
    private final Map<String, Object> pathSpec;
    private final MetadataStorageUpdaterJobSpec metadataUpdateSpec;
    private final String segmentOutputPath;

    @JsonCreator
    public HadoopIOConfig(@JsonProperty(value="inputSpec") Map<String, Object> pathSpec, @JsonProperty(value="metadataUpdateSpec") MetadataStorageUpdaterJobSpec metadataUpdateSpec, @JsonProperty(value="segmentOutputPath") String segmentOutputPath) {
        this.pathSpec = pathSpec;
        this.metadataUpdateSpec = metadataUpdateSpec;
        this.segmentOutputPath = segmentOutputPath;
    }

    @JsonProperty(value="inputSpec")
    public Map<String, Object> getPathSpec() {
        return this.pathSpec;
    }

    @JsonProperty(value="metadataUpdateSpec")
    public MetadataStorageUpdaterJobSpec getMetadataUpdateSpec() {
        return this.metadataUpdateSpec;
    }

    @JsonProperty
    public String getSegmentOutputPath() {
        return this.segmentOutputPath;
    }

    public HadoopIOConfig withSegmentOutputPath(String path) {
        return new HadoopIOConfig(this.pathSpec, this.metadataUpdateSpec, path);
    }
}

