/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.collect.ImmutableList;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.RE;
import io.druid.java.util.common.collect.Utils;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.common.parsers.ParseException;
import io.druid.segment.indexing.granularity.GranularitySpec;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class HadoopDruidIndexerMapper<KEYOUT, VALUEOUT>
extends Mapper<Object, Object, KEYOUT, VALUEOUT> {
    private static final Logger log = new Logger(HadoopDruidIndexerMapper.class);
    protected HadoopDruidIndexerConfig config;
    private InputRowParser parser;
    protected GranularitySpec granularitySpec;
    private boolean reportParseExceptions;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
        this.parser = this.config.getParser();
        this.granularitySpec = this.config.getGranularitySpec();
        this.reportParseExceptions = !this.config.isIgnoreInvalidRows();
    }

    public HadoopDruidIndexerConfig getConfig() {
        return this.config;
    }

    protected void map(Object key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<InputRow> inputRows;
            try {
                inputRows = HadoopDruidIndexerMapper.parseInputRow(value, this.parser);
            }
            catch (ParseException e) {
                if (this.reportParseExceptions) {
                    throw e;
                }
                log.debug((Throwable)e, "Ignoring invalid row [%s] due to parsing error", new Object[]{value});
                context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER).increment(1L);
                return;
            }
            for (InputRow inputRow : inputRows) {
                if (inputRow == null) {
                    log.debug("Throwing away row [%s]", new Object[]{value});
                    continue;
                }
                if (this.granularitySpec.bucketIntervals().isPresent() && !this.granularitySpec.bucketInterval(DateTimes.utc((long)inputRow.getTimestampFromEpoch())).isPresent()) continue;
                this.innerMap(inputRow, context, this.reportParseExceptions);
            }
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "Failure on row[%s]", new Object[]{value});
        }
    }

    private static List<InputRow> parseInputRow(Object value, InputRowParser parser) {
        if (parser instanceof StringInputRowParser && value instanceof Text) {
            return Utils.nullableListOf((Object[])new InputRow[]{((StringInputRowParser)parser).parse(value.toString())});
        }
        if (value instanceof InputRow) {
            return ImmutableList.of((Object)((InputRow)value));
        }
        if (value == null) {
            return Utils.nullableListOf((Object[])new InputRow[]{null});
        }
        return parser.parseBatch(value);
    }

    protected abstract void innerMap(InputRow var1, Mapper.Context var2, boolean var3) throws IOException, InterruptedException;
}

