/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi.strategies;

import com.codahale.metrics.jdbi.strategies.StatementNameStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.skife.jdbi.v2.StatementContext;

public abstract class DelegatingStatementNameStrategy
implements StatementNameStrategy {
    private final List<StatementNameStrategy> strategies = new ArrayList<StatementNameStrategy>();

    protected DelegatingStatementNameStrategy(StatementNameStrategy ... strategies) {
        this.registerStrategies(strategies);
    }

    protected void registerStrategies(StatementNameStrategy ... strategies) {
        this.strategies.addAll(Arrays.asList(strategies));
    }

    @Override
    public String getStatementName(StatementContext statementContext) {
        for (StatementNameStrategy strategy : this.strategies) {
            String statementName = strategy.getStatementName(statementContext);
            if (statementName == null) continue;
            return statementName;
        }
        return "sql.unknown";
    }
}

