/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.servlets;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.json.HealthCheckModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ExecutorService;

public class HealthCheckServlet
extends HttpServlet {
    public static final String HEALTH_CHECK_REGISTRY = HealthCheckServlet.class.getCanonicalName() + ".registry";
    public static final String HEALTH_CHECK_EXECUTOR = HealthCheckServlet.class.getCanonicalName() + ".executor";
    public static final String HEALTH_CHECK_FILTER = HealthCheckServlet.class.getCanonicalName() + ".healthCheckFilter";
    private static final long serialVersionUID = -8432996484889177321L;
    private static final String CONTENT_TYPE = "application/json";
    private transient HealthCheckRegistry registry;
    private transient ExecutorService executorService;
    private transient HealthCheckFilter filter;
    private transient ObjectMapper mapper;

    public HealthCheckServlet() {
    }

    public HealthCheckServlet(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    public void init(ServletConfig config) throws ServletException {
        Object filterAttr;
        Object executorAttr;
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(HEALTH_CHECK_REGISTRY);
            if (registryAttr instanceof HealthCheckRegistry) {
                this.registry = (HealthCheckRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a HealthCheckRegistry instance.");
            }
        }
        if ((executorAttr = context.getAttribute(HEALTH_CHECK_EXECUTOR)) instanceof ExecutorService) {
            this.executorService = (ExecutorService)executorAttr;
        }
        if ((filterAttr = context.getAttribute(HEALTH_CHECK_FILTER)) instanceof HealthCheckFilter) {
            this.filter = (HealthCheckFilter)filterAttr;
        }
        if (this.filter == null) {
            this.filter = HealthCheckFilter.ALL;
        }
        this.mapper = new ObjectMapper().registerModule((Module)new HealthCheckModule());
    }

    public void destroy() {
        super.destroy();
        this.registry.shutdown();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SortedMap<String, HealthCheck.Result> results = this.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (results.isEmpty()) {
            resp.setStatus(501);
        } else if (HealthCheckServlet.isAllHealthy(results)) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.getWriter(req).writeValue((OutputStream)output, results);
        }
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private SortedMap<String, HealthCheck.Result> runHealthChecks() {
        if (this.executorService == null) {
            return this.registry.runHealthChecks(this.filter);
        }
        return this.registry.runHealthChecks(this.executorService, this.filter);
    }

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public static abstract class ContextListener
    implements ServletContextListener {
        protected abstract HealthCheckRegistry getHealthCheckRegistry();

        protected ExecutorService getExecutorService() {
            return null;
        }

        protected HealthCheckFilter getHealthCheckFilter() {
            return HealthCheckFilter.ALL;
        }

        public void contextInitialized(ServletContextEvent event) {
            ServletContext context = event.getServletContext();
            context.setAttribute(HEALTH_CHECK_REGISTRY, (Object)this.getHealthCheckRegistry());
            context.setAttribute(HEALTH_CHECK_EXECUTOR, (Object)this.getExecutorService());
        }

        public void contextDestroyed(ServletContextEvent event) {
        }
    }
}

