/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.servlet;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractInstrumentedFilter
implements Filter {
    static final String METRIC_PREFIX = "name-prefix";
    private final String otherMetricName;
    private final Map<Integer, String> meterNamesByStatusCode;
    private final String registryAttribute;
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Meter timeoutsMeter;
    private Meter errorsMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    protected AbstractInstrumentedFilter(String registryAttribute, Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.registryAttribute = registryAttribute;
        this.otherMetricName = otherMetricName;
        this.meterNamesByStatusCode = meterNamesByStatusCode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        MetricRegistry metricsRegistry = this.getMetricsFactory(filterConfig);
        String metricName = filterConfig.getInitParameter(METRIC_PREFIX);
        if (metricName == null || metricName.isEmpty()) {
            metricName = this.getClass().getName();
        }
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{entry.getValue()})));
        }
        this.otherMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{this.otherMetricName}));
        this.timeoutsMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"timeouts"}));
        this.errorsMeter = metricsRegistry.meter(MetricRegistry.name((String)metricName, (String[])new String[]{"errors"}));
        this.activeRequests = metricsRegistry.counter(MetricRegistry.name((String)metricName, (String[])new String[]{"activeRequests"}));
        this.requestTimer = metricsRegistry.timer(MetricRegistry.name((String)metricName, (String[])new String[]{"requests"}));
    }

    private MetricRegistry getMetricsFactory(FilterConfig filterConfig) {
        Object o = filterConfig.getServletContext().getAttribute(this.registryAttribute);
        MetricRegistry metricsRegistry = o instanceof MetricRegistry ? (MetricRegistry)o : new MetricRegistry();
        return metricsRegistry;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        boolean error = false;
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        catch (ServletException | IOException | RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            if (!error && request.isAsyncStarted()) {
                request.getAsyncContext().addListener((AsyncListener)new AsyncResultListener(context));
            } else {
                context.stop();
                this.activeRequests.dec();
                if (error) {
                    this.errorsMeter.mark();
                } else {
                    this.markMeterForStatusCode(wrappedResponse.getStatus());
                }
            }
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private class AsyncResultListener
    implements AsyncListener {
        private Timer.Context context;
        private boolean done = false;

        public AsyncResultListener(Timer.Context context) {
            this.context = context;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            if (!this.done) {
                HttpServletResponse suppliedResponse = (HttpServletResponse)event.getSuppliedResponse();
                this.context.stop();
                AbstractInstrumentedFilter.this.activeRequests.dec();
                AbstractInstrumentedFilter.this.markMeterForStatusCode(suppliedResponse.getStatus());
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.context.stop();
            AbstractInstrumentedFilter.this.activeRequests.dec();
            AbstractInstrumentedFilter.this.timeoutsMeter.mark();
            this.done = true;
        }

        public void onError(AsyncEvent event) throws IOException {
            this.context.stop();
            AbstractInstrumentedFilter.this.activeRequests.dec();
            AbstractInstrumentedFilter.this.errorsMeter.mark();
            this.done = true;
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

